/*
 * Decompiled with CFR 0.152.
 */
package com.mobilepetroleum.radialencapsulation;

import classycle.Analyser;
import classycle.ClassAttributes;
import classycle.graph.AtomicVertex;
import classycle.graph.Vertex;
import classycle.util.StringPattern;
import com.mobilepetroleum.radialencapsulation.Files;
import com.mobilepetroleum.radialencapsulation.StringPatterns;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="radial-encapsulation", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class RadialEncapsulation
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(property="includeTestSources", defaultValue="true")
    boolean includeTestSources;
    @Parameter(property="excludes")
    String[] excludes = new String[0];
    @Parameter(property="basePackage", required=true)
    String basePackage;
    @Parameter(property="maxViolations")
    Integer maxViolations;
    StringPattern excludePattern;

    public void execute() throws MojoExecutionException {
        this.excludePattern = StringPatterns.exclude(this.excludes);
        List<String> dirs = new ArrayList<String>();
        dirs.add(this.project.getBuild().getOutputDirectory());
        if (this.includeTestSources) {
            dirs.add(this.project.getBuild().getTestOutputDirectory());
        }
        dirs = Files.removeMissingFiles(dirs, this.getLog());
        Analyser analyser = new Analyser(dirs.toArray(new String[dirs.size()]), this.excludePattern, null, true);
        AtomicVertex[] classGraph = analyser.getClassGraph();
        int violations = 0;
        for (AtomicVertex currentVertex : classGraph) {
            String inspectedType = ((ClassAttributes)currentVertex.getAttributes()).getName();
            int numberOfIncomingArcs = currentVertex.getNumberOfOutgoingArcs();
            for (int i = 0; i < numberOfIncomingArcs; ++i) {
                Vertex vertex = currentVertex.getHeadVertex(i);
                ClassAttributes dependency = (ClassAttributes)vertex.getAttributes();
                String dependencyType = dependency.getName();
                if (this.accepts(inspectedType, dependencyType)) continue;
                this.getLog().info((CharSequence)(inspectedType + " -> " + dependencyType));
                ++violations;
            }
        }
        if (violations == 0) {
            this.getLog().info((CharSequence)"No violations found");
        } else {
            this.getLog().info((CharSequence)("Found " + violations + " violations"));
        }
        if (this.maxViolations != null && violations > this.maxViolations) {
            String message = "Exceeded max violations. Max violations = " + this.maxViolations + ", violations = " + violations;
            throw new MojoExecutionException(message);
        }
    }

    boolean accepts(String base, String dependency) {
        if (!dependency.startsWith(this.basePackage) || !this.excludePattern.matches(dependency)) {
            return true;
        }
        base = base.substring(0, base.lastIndexOf(46));
        dependency = dependency.substring(0, dependency.lastIndexOf(46));
        return base.startsWith(dependency);
    }
}

