/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.blade.mojo;

import com.backbase.oss.blade.model.Blade;
import com.backbase.oss.blade.model.Stage;
import com.backbase.oss.blade.model.WebApp;
import com.backbase.oss.blade.utils.BladeUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBladeMojo
extends AbstractMojo {
    private static final String BACKBASE_CONFIG_DIR = "backbase.config.dir";
    private static final String ESAPI_RESOURCES = "org.owasp.esapi.resources";
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractBladeMojo.class.getName());
    private static final String SLASH = "/";
    protected static final int SHUTDOWN_DEFAULT_PORT = 2019;
    @Parameter(defaultValue="false")
    protected boolean fork;
    @Parameter(defaultValue="${project.artifactId}")
    private String id;
    @Parameter(defaultValue="${project.name}")
    private String name;
    @Parameter(defaultValue="8080")
    int port;
    @Parameter(defaultValue="-1")
    int shutdownPort;
    @Parameter(defaultValue="8443")
    int securePort;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private Map systemProperties;
    @Parameter(defaultValue="${project.basedir}/config/backbase/")
    private File backbaseConfigDir;
    @Parameter(defaultValue="${project.build.directory}/tomcat")
    File catalinaHome;
    @Parameter(defaultValue="${project.basedir}/config/tomcat/conf/Catalina/localhost/")
    private File contextFileDir;
    @Parameter(defaultValue="false")
    private boolean multiThreaded;
    @Parameter(defaultValue="false")
    private boolean detectAndConfigureSpringConfigLocation;
    @Parameter
    List<Stage> stages;
    @Parameter
    List<WebApp> bootstrapped;
    @Parameter(defaultValue="http://localhost:8080")
    private URL masterBladeAddress;
    @Parameter(defaultValue="true")
    protected boolean enableBladeConsole;
    @Parameter(defaultValue="false")
    protected boolean enableApplicationReload;

    AbstractBladeMojo() {
    }

    Blade initializeStages() throws MojoExecutionException {
        if (this.stages == null || this.stages.isEmpty()) {
            this.autoconfigureStages();
        } else {
            for (Stage stage : this.stages) {
                if (stage.getName() == null) {
                    stage.setName(stage.getId());
                }
                for (WebApp webApp : stage.getWebApps()) {
                    this.setup(webApp);
                }
            }
        }
        try {
            Blade blade = new Blade(this.id);
            blade.setName(this.name);
            blade.setPort(this.port);
            blade.setSecurePort(this.securePort);
            blade.setStages(this.stages);
            blade.setReady(false);
            blade.setBladeMaster(this.masterBladeAddress);
            blade.setReloadable(this.enableApplicationReload);
            return blade;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot initialize blade.json", e);
        }
    }

    private void autoconfigureStages() {
        this.stages = new ArrayList<Stage>();
        Stage stage = new Stage();
        stage.setAutoStart(true);
        stage.setId(this.project.getArtifactId());
        List<WebApp> bootstrappedApps = this.getBootstrappedApps(this.project);
        if (this.project.getPackaging().equals("pom")) {
            stage.setWebApps(bootstrappedApps);
        } else if (this.project.getPackaging().equals("war") && bootstrappedApps.size() == 1) {
            for (WebApp webApp : bootstrappedApps) {
                File docBase = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName());
                logger.info("Setting Doc Base for Web App: {} to: {}", (Object)webApp.getName(), (Object)docBase);
                webApp.setDocBase(docBase);
            }
            stage.setWebApps(bootstrappedApps);
        }
        if (bootstrappedApps.size() == 1) {
            for (WebApp webApp : bootstrappedApps) {
                if (!this.detectAndConfigureSpringConfigLocation) continue;
                this.detectAndConfigureSpringConfigLocation(this.project, webApp);
            }
        }
        stage.setMultiThreaded(this.multiThreaded);
        this.stages.add(stage);
    }

    private Artifact getArtifact(MavenProject mavenProject, WebApp webApp) {
        Set artifacts = mavenProject.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!artifact.getGroupId().equals(webApp.getGroupId()) || !artifact.getArtifactId().equals(webApp.getArtifactId()) || artifact.getClassifier() != null && artifact.getClassifier().equals("war")) continue;
            return artifact;
        }
        return null;
    }

    private List<Artifact> getSubModuleArtifacts(MavenProject mavenProject) {
        return mavenProject.getArtifacts().stream().filter(artifact -> !mavenProject.getParent().getArtifacts().contains(artifact)).filter(this::isWar).collect(Collectors.toList());
    }

    private void detectAndConfigureSpringConfigLocation(MavenProject mavenProject, WebApp webApp) {
        File applicationYaml = new File(mavenProject.getBasedir(), "application.yml");
        if (applicationYaml.exists()) {
            if (webApp.isSpringBoot1App()) {
                webApp.getEnvironmentVariables().put("spring.config.location", applicationYaml.getAbsolutePath());
            } else {
                webApp.getEnvironmentVariables().put("spring.config.additional-location", applicationYaml.getAbsolutePath());
            }
        }
    }

    private List<Artifact> getWarDependencies(MavenProject mavenProject) {
        return mavenProject.getArtifacts().stream().filter(this::isWar).collect(Collectors.toList());
    }

    private List<WebApp> getBootstrappedApps(MavenProject mavenProject) {
        return this.getWarDependencies(mavenProject).stream().map(artifact -> {
            WebApp webApp = new WebApp();
            this.mapArtifact(webApp, (Artifact)artifact);
            return webApp;
        }).collect(Collectors.toList());
    }

    private boolean isWar(Artifact artifact) {
        return artifact.getType().equals("war");
    }

    private void setup(WebApp webApp) throws MojoExecutionException {
        File contextFile;
        MavenProject mavenProject;
        if (webApp.getModule() == null) {
            mavenProject = this.project;
        } else {
            mavenProject = this.getMavenSubModule(webApp);
            this.copyConfigurationFilesIntoTarget(webApp, mavenProject);
        }
        if (webApp.getDocBase() == null && webApp.getModule() != null) {
            this.setSubmoduleWebApp(webApp, mavenProject);
        } else {
            this.mapMavenAsWebApp(webApp, mavenProject);
        }
        if (this.detectAndConfigureSpringConfigLocation) {
            this.detectAndConfigureSpringConfigLocation(mavenProject, webApp);
        }
        if (webApp.getVersion() == null) {
            webApp.setVersion(mavenProject.getVersion());
        }
        String contextPath = webApp.getContextPath() != null ? webApp.getContextPath() : webApp.getArtifactId();
        contextPath = this.ensureContextPathStartsWithSlash(contextPath);
        webApp.setName(webApp.getName() == null ? contextPath : webApp.getName());
        webApp.setContextPath(contextPath);
        if (StringUtils.isEmpty((String)webApp.getUrl())) {
            webApp.setUrl(contextPath);
        }
        if ((contextFile = this.getContextFile(contextPath)).exists()) {
            webApp.setContextFileLocation(contextFile);
        }
        logger.debug("*********");
        this.log("Name", webApp.getName());
        this.log("GroupID", webApp.getGroupId());
        this.log("ArtifactId", webApp.getArtifactId());
        this.log("Version", webApp.getVersion());
        this.log("DocBase", webApp.getDocBase());
        this.log("Maven Sub Module", webApp.getModule());
        this.log("Context Path", webApp.getContextPath());
        this.log("Context File", webApp.getContextFileLocation());
        this.log("GroupID", webApp.getGroupId());
        logger.debug("**********");
    }

    private void mapMavenAsWebApp(WebApp webApp, MavenProject mavenProject) {
        Artifact artifact = this.getArtifact(mavenProject, webApp);
        if (artifact != null) {
            this.mapArtifact(webApp, artifact);
        }
    }

    private void setSubmoduleWebApp(WebApp webApp, MavenProject mavenProject) throws MojoExecutionException {
        if (mavenProject.getPackaging().equals("pom")) {
            List<Artifact> subModuleWarDependencies = this.getSubModuleArtifacts(mavenProject);
            int size = subModuleWarDependencies.size();
            if (size == 0) {
                throw new MojoExecutionException("Cannot setup Web Application from submodule " + mavenProject.getName() + " as no WAR dependency is setup as a Dependency");
            }
            if (size > 1) {
                throw new MojoExecutionException("Cannot setup Web Application from submodule " + mavenProject.getName() + ". Mapping sub modules in Blade requires a single WAR dependency");
            }
            this.mapArtifact(webApp, subModuleWarDependencies.get(0));
        } else {
            this.mapArtifact(webApp, mavenProject.getArtifact());
            File docBase = new File(mavenProject.getBuild().getDirectory(), mavenProject.getBuild().getFinalName());
            logger.info("Setting Doc Base for submodule: {} to: {}", (Object)webApp.getModule(), (Object)docBase);
            webApp.setDocBase(docBase);
        }
    }

    private void log(String label, Object value) {
        if (value != null && logger.isDebugEnabled()) {
            logger.debug("{}:{}", (Object)StringUtils.left((String)label, (int)20), value);
        }
    }

    private void copyConfigurationFilesIntoTarget(WebApp webApp, MavenProject mavenProject) throws MojoExecutionException {
        File projectConfigDirectory = new File(mavenProject.getBasedir(), "config");
        if (projectConfigDirectory.exists()) {
            try {
                FileUtils.copyDirectoryStructure((File)projectConfigDirectory, (File)this.backbaseConfigDir.getParentFile());
                logger.info("Copying module configuration files from: {} to: {} ", (Object)projectConfigDirectory, (Object)this.backbaseConfigDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot copy configuration files from module: " + webApp, (Exception)e);
            }
        }
    }

    private MavenProject getMavenSubModule(WebApp webApp) throws MojoExecutionException {
        Optional<MavenProject> optionalMavenProject = this.project.getCollectedProjects().stream().filter(p -> p.getArtifactId().equals(webApp.getModule())).findFirst();
        if (!optionalMavenProject.isPresent()) {
            throw new MojoExecutionException("Cannot find maven module: " + webApp.getModule() + " as submodule of this project");
        }
        return optionalMavenProject.get();
    }

    private void mapArtifact(WebApp webApp, Artifact artifact) {
        webApp.setArtifactId(artifact.getArtifactId());
        webApp.setGroupId(artifact.getGroupId());
        webApp.setDocBase(artifact.getFile());
        webApp.setVersion(artifact.getVersion());
    }

    private String ensureContextPathStartsWithSlash(String contextPath) {
        if (!contextPath.startsWith(SLASH) && !contextPath.endsWith(SLASH)) {
            contextPath = SLASH + contextPath;
        }
        return contextPath;
    }

    private File getContextFile(String contextPath) {
        return new File(this.contextFileDir, contextPath + ".xml");
    }

    void setupSystemProperties() throws MojoExecutionException {
        Map properties = this.getSystemProperties();
        if (properties.values().stream().anyMatch(Objects::isNull)) {
            throw new MojoExecutionException("systemProperties cannot contain null values! " + properties.toString());
        }
        System.getProperties().putAll((Map<?, ?>)properties);
        if (!properties.containsKey(BACKBASE_CONFIG_DIR)) {
            System.getProperties().put(BACKBASE_CONFIG_DIR, this.backbaseConfigDir.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("backbase.config.dir property set to: " + properties.get(BACKBASE_CONFIG_DIR)));
        if (!properties.containsKey(ESAPI_RESOURCES)) {
            System.getProperties().put(ESAPI_RESOURCES, this.catalinaHome.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("org.owasp.esapi.resources property set to: " + properties.get(ESAPI_RESOURCES)));
        this.printSystemProperties(System.getProperties());
    }

    private Map getSystemProperties() {
        HashMap properties = this.systemProperties;
        if (properties == null) {
            properties = new HashMap();
        }
        return properties;
    }

    void testTomcatPort() throws MojoExecutionException {
        if (!BladeUtils.isPortAvailable((int)this.port)) {
            String message = "Port " + this.port + " already in use.";
            logger.error(message);
            throw new MojoExecutionException(message);
        }
    }

    int getShutdownPort() {
        if (this.shutdownPort == -1 && BladeUtils.isPortAvailable((int)2019)) {
            logger.info("Shutdown port: {} ", (Object)2019);
            return 2019;
        }
        if (this.shutdownPort != -1 && BladeUtils.isPortAvailable((int)this.shutdownPort)) {
            logger.info("Shutdown port: {}", (Object)this.shutdownPort);
            return this.shutdownPort;
        }
        if (this.shutdownPort != -1) {
            logger.warn("Shutdown port {} already in use.", (Object)this.shutdownPort);
        }
        return -1;
    }

    void createCatalinaHome() throws MojoExecutionException {
        if (!this.catalinaHome.exists() && !this.catalinaHome.mkdirs()) {
            throw new MojoExecutionException("Cannot create Tomcat Catalina Home directory: " + this.catalinaHome.getAbsolutePath());
        }
    }

    private void printSystemProperties(Properties systemProperties) {
        logger.debug("System Properties:");
        systemProperties.stringPropertyNames().stream().sorted().forEach(property -> logger.debug("{}={}", property, systemProperties.get(property)));
    }

    void copyInputStreamToFile(File targetFile, InputStream inputStream) throws IOException {
        Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitIndefinitely() throws MojoExecutionException {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                throw new MojoExecutionException("InterruptedException on wait Indefinitely lock:" + exception.getMessage(), (Exception)exception);
            }
        }
    }
}

