/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.blade.mojo;

import com.backbase.oss.blade.model.Blade;
import com.backbase.oss.blade.model.WebApp;
import com.backbase.oss.blade.mojo.AbstractBladeMojo;
import com.backbase.oss.blade.tomcat.BladeTomcat;
import com.backbase.oss.blade.tomcat.BladeTomcatBuilder;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, aggregator=true)
@Execute(phase=LifecyclePhase.PACKAGE)
public class BladeRunMojo
extends AbstractBladeMojo {
    private static final String JOLOKIA_WAR_1_3_7_WAR = "jolokia-war-1.3.7.war";
    private static final Logger logger = LoggerFactory.getLogger(BladeRunMojo.class);
    private static final String SELFSIGNED_JKS = "selfsigned.jks";
    @Parameter(defaultValue="true")
    private boolean enableJolokia;
    @Parameter(defaultValue="false")
    private boolean enableGzip;
    @Parameter(defaultValue="false")
    private boolean enableHttps;
    @Parameter(defaultValue="tomcat")
    private String keyAlias;
    @Parameter(defaultValue="backbase")
    private String keystorePass;
    @Parameter(defaultValue="JKS")
    private String keystoreType;
    @Parameter(defaultValue="${project.build.directory}/selfsigned.jks")
    private String keystoreFile;
    @Parameter(defaultValue="false")
    private boolean openBrowserOnStartup;
    @Parameter(property="connector.maxThreads", defaultValue="20")
    private int maxThreads;
    @Parameter(property="connector.maxThreads.dynamic", defaultValue="false")
    private boolean dynamicMaxThreads;
    @Parameter(property="connector.maxHttpHeaderSize", defaultValue="65000")
    private int maxHttpHeaderSize;
    @Parameter(defaultValue="")
    private String bladeConsoleContextPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.testTomcatPort();
        this.createCatalinaHome();
        this.setupSystemProperties();
        Blade blade = this.initializeStages();
        this.copyEsapiProperties();
        try {
            File webapps = new File(this.catalinaHome, "webapps");
            if (webapps.exists()) {
                this.getLog().info((CharSequence)"Cleaning up previous blade");
                FileUtils.deleteDirectory((File)webapps);
            }
            if (this.bootstrapped == null) {
                this.bootstrapped = new ArrayList();
            }
            ArrayList<WebApp> bootstrappedApps = new ArrayList<WebApp>(this.bootstrapped);
            if (this.enableBladeConsole) {
                this.addBladeWar(bootstrappedApps);
            }
            if (this.enableJolokia) {
                this.addJolokiaWar(bootstrappedApps);
            }
            if (this.enableHttps) {
                this.copySelfSignedCertificateToTarget();
            }
            BladeTomcat tomcat = new BladeTomcatBuilder().setCatalinaHome(this.catalinaHome).setBootstrappedWebApps(bootstrappedApps).setBlade(blade).setEnableGzip(this.enableGzip).setMaxThreads(this.maxThreads).setDynamicMaxThreads(this.dynamicMaxThreads).setEnableHttps(this.enableHttps).setKeyAlias(this.keyAlias).setKeystorePass(this.keystorePass).setKeystoreType(this.keystoreType).setKeystoreFile(this.keystoreFile).setEnableBladeConsole(this.enableBladeConsole).setMaxHttpHeaderSize(this.maxHttpHeaderSize).build();
            tomcat.getServer().setPort(this.getShutdownPort());
            tomcat.startBladeServer();
            if (this.enableBladeConsole) {
                if (this.openBrowserOnStartup && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI("http://localhost:" + this.port));
                } else {
                    logger.warn("{} Desktop API BROWSE in this platform is not supported.", (Object)System.getProperty("os.name"));
                }
            }
            tomcat.autoStartStages();
            if (!this.fork) {
                tomcat.getServer().await();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void copyEsapiProperties() throws MojoFailureException {
        File target = new File(this.catalinaHome, "ESAPI.properties");
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/ESAPI.properties");
        try {
            this.copyInputStreamToFile(target, inputStream);
        }
        catch (IOException e) {
            throw new MojoFailureException("Cannot copy ESAPI.properties");
        }
    }

    private void addJolokiaWar(List<WebApp> webapps) throws IOException {
        this.addWebApp(webapps, JOLOKIA_WAR_1_3_7_WAR, "/jolokia", false, false);
    }

    private void addBladeWar(List<WebApp> webApps) throws IOException {
        String contextPath = StringUtils.isEmpty((String)this.bladeConsoleContextPath) ? "" : this.bladeConsoleContextPath;
        this.addWebApp(webApps, "blade-webapp.war", contextPath, true, true);
    }

    private void addWebApp(List<WebApp> webapps, String warFile, String contextPath, boolean isPrivileged, boolean inheritClassloader) throws IOException {
        logger.info("Adding bootstrapped webapp: {} with contextPath: {}", (Object)warFile, (Object)contextPath);
        File deploymentDirectory = new File(this.catalinaHome, "webapps");
        deploymentDirectory.mkdirs();
        File targetFile = new File(deploymentDirectory, warFile);
        if (!targetFile.exists()) {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + warFile);
            this.copyInputStreamToFile(targetFile, inputStream);
        }
        WebApp webApp = new WebApp(targetFile, contextPath, null);
        webApp.setPrivileged(isPrivileged);
        webApp.setInheritClassloader(inheritClassloader);
        webApp.setName(warFile);
        webapps.add(webApp);
    }

    private void copySelfSignedCertificateToTarget() throws IOException {
        File target = new File(this.keystoreFile);
        if (!target.exists()) {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/selfsigned.jks");
            this.copyInputStreamToFile(target, inputStream);
        }
    }
}

