/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.DerefenceException;
import com.backbase.oss.boat.ExampleUtils;
import com.backbase.oss.boat.ExportException;
import com.backbase.oss.boat.ExporterOptions;
import com.backbase.oss.boat.JsonSchemaToOpenApi;
import com.backbase.oss.boat.RamlSchemaToOpenApi;
import com.backbase.oss.boat.Utils;
import com.backbase.oss.boat.loader.CachingResourceLoader;
import com.backbase.oss.boat.loader.RamlResourceLoader;
import com.backbase.oss.boat.transformers.Transformer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.CaseFormat;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.api.Library;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeInstance;
import org.raml.v2.api.model.v10.datamodel.TypeInstanceProperty;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;
import org.raml.v2.api.model.v10.system.types.MarkdownString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exporter {
    private static final Logger log = LoggerFactory.getLogger(Exporter.class);
    private static final Pattern placeholderPattern = Pattern.compile("(\\{[^}]*\\})");
    public static final String X_EXAMPLES = "x-examples";
    public static final String NO_DESCRIPTION_AVAILABLE = "No description available";
    public static final String NEW_LINE = "\n";
    public static final String EXAMPLE = "example";
    private static final ObjectMapper mapper = Utils.createObjectMapper();
    private final ExporterOptions exporterOptions;

    private Exporter(ExporterOptions exporterOptions) {
        this.exporterOptions = exporterOptions;
    }

    public static OpenAPI export(File inputFile, boolean addJavaTypeExtensions, List<Transformer> transformers) throws ExportException {
        ExporterOptions exporterOptions = new ExporterOptions();
        exporterOptions.setAddJavaTypeExtensions(addJavaTypeExtensions);
        exporterOptions.setTransformers(transformers);
        return Exporter.export(inputFile, exporterOptions);
    }

    public static OpenAPI export(File inputFile, ExporterOptions options) throws ExportException {
        AtomicReference<String> serviceName = new AtomicReference<String>("serviceName");
        Object[] split = inputFile.getPath().split("/");
        ArrayUtils.reverse((Object[])split);
        Arrays.stream(split).filter(part -> part.endsWith("-spec")).findFirst().ifPresent(s -> serviceName.set(s.replace("-spec", "-service")));
        log.debug("Export: {} with options: {}", (Object)inputFile, (Object)options);
        return new Exporter(options).export(serviceName.get(), inputFile);
    }

    private OpenAPI export(String serviceName, File inputFile) throws ExportException {
        File parentFile = inputFile.getParentFile();
        URL baseUrl = parentFile.toURI().toURL();
        TreeMap<String, String> ramlTypeReferences = new TreeMap<String, String>();
        try {
            String ramlAsString = new String(Files.readAllBytes(inputFile.toPath()), Charset.defaultCharset());
            JsonNode jsonNode = mapper.readTree(ramlAsString);
            this.parseRamlTypeReferences(baseUrl, ramlTypeReferences, jsonNode);
        }
        catch (Exception e) {
            throw new ExportException("Failed to export ramlTypes", e);
        }
        CachingResourceLoader resourceLoader = new CachingResourceLoader(new RamlResourceLoader(inputFile, inputFile.getParentFile()));
        RamlModelBuilder ramlModelBuilder = new RamlModelBuilder((ResourceLoader)resourceLoader);
        RamlModelResult ramlModelResult = ramlModelBuilder.buildApi(inputFile);
        this.validateRamlModelResult(inputFile, ramlModelResult);
        Api ramlApi = ramlModelResult.getApiV10();
        Components components = new Components();
        components.setSchemas(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        JsonSchemaToOpenApi jsonSchemaToOpenApi = new JsonSchemaToOpenApi(baseUrl, components, ramlTypeReferences);
        assert (ramlApi != null);
        Map<String, TypeDeclaration> types = this.collectTypesFromRamlSpec(ramlApi);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        log.debug("Converting RAML Types from Spec and Libraries");
        for (Map.Entry<String, TypeDeclaration> entry : types.entrySet()) {
            String name = entry.getKey();
            TypeDeclaration typeDeclaration = entry.getValue();
            String schemaName = Utils.normalizeSchemaName(name);
            Schema typeSchema = typeDeclaration instanceof JSONTypeDeclaration ? jsonSchemaToOpenApi.convert(schemaName, (JSONTypeDeclaration)typeDeclaration) : RamlSchemaToOpenApi.convert(schemaName, typeDeclaration, components);
            if (typeDeclaration.examples() != null && !typeDeclaration.examples().isEmpty()) {
                List examples = typeDeclaration.examples().stream().map(exampleSpec -> new Example().value(ExampleUtils.getExampleObject(exampleSpec, this.exporterOptions.isConvertExamplesToYaml())).summary(exampleSpec.name())).collect(Collectors.toList());
                typeSchema.addExtension(X_EXAMPLES, examples);
            }
            log.debug("Added type: {}", (Object)typeSchema.getName());
        }
        ArrayList schemas = new ArrayList(components.getSchemas().values());
        for (Schema schema2 : schemas) {
            try {
                jsonSchemaToOpenApi.dereferenceSchema(schema2, components);
            }
            catch (Exception e) {
                throw new ExportException("Failed to dereference schema", e);
            }
        }
        components.getSchemas().values().forEach(schema1 -> Utils.cleanUp(schema1, !this.exporterOptions.isAddJavaTypeExtensions()));
        Info info = this.setupInfo(ramlApi);
        List<Tag> tags = this.setupTags(ramlApi);
        String url = "/" + serviceName + "/";
        LinkedList<Server> servers = new LinkedList<Server>();
        servers.add(new Server().url(url).description("The server").variables(null));
        Paths paths = new Paths();
        String ramlBaseUrl = this.buildBaseUri(ramlApi);
        try {
            this.convertResources(ramlBaseUrl, ramlApi.resources(), paths, components, jsonSchemaToOpenApi, operations);
        }
        catch (DerefenceException e) {
            throw new ExportException("Faield to defererence resources", e);
        }
        OpenAPI openAPI = new OpenAPI();
        openAPI.setOpenapi("3.0.3");
        openAPI.setInfo(info);
        openAPI.setTags(tags);
        openAPI.setServers(servers);
        openAPI.setComponents(components);
        openAPI.setPaths(paths);
        schemas = new ArrayList(components.getSchemas().values());
        for (Schema schema3 : schemas) {
            try {
                jsonSchemaToOpenApi.dereferenceSchema(schema3, components);
            }
            catch (Exception e) {
                throw new ExportException("Failed to dereference schema", e);
            }
        }
        components.getSchemas().values().forEach(schema -> Utils.cleanUp(schema, !this.exporterOptions.isAddJavaTypeExtensions()));
        this.exporterOptions.getTransformers().forEach(transformer -> transformer.transform(openAPI, new HashMap<String, Object>()));
        return openAPI;
    }

    private String buildBaseUri(Api ramlApi) {
        if (ramlApi.baseUri() == null) {
            return "/";
        }
        String ramlBaseUrl = ramlApi.baseUri().value();
        if (!ramlBaseUrl.startsWith("/")) {
            ramlBaseUrl = "/" + ramlBaseUrl;
        }
        if (ramlBaseUrl.contains("{version}")) {
            ramlBaseUrl = StringUtils.replace((String)ramlBaseUrl, (String)"{version}", (String)ramlApi.version().value());
        }
        return ramlBaseUrl;
    }

    private Info setupInfo(Api ramlApi) {
        log.debug("Setup Description");
        String version = ramlApi.version() != null ? ramlApi.version().value() : "1.0";
        Info info = new Info().title(ramlApi.title().value()).version(version);
        StringBuilder markdown = new StringBuilder();
        if (this.isNotBlank((AnnotableStringType)ramlApi.description())) {
            markdown.append(ramlApi.description().value()).append(NEW_LINE);
        }
        if (ramlApi.documentation() != null) {
            ramlApi.documentation().forEach(documentationItem -> {
                String title = null;
                String documentation = null;
                if (this.isNotBlank(documentationItem.title())) {
                    title = documentationItem.title().value();
                }
                if (this.isNotBlank((AnnotableStringType)documentationItem.content())) {
                    documentation = documentationItem.content().value();
                }
                if (documentation != null && documentation.startsWith("# ")) {
                    markdown.append(documentationItem.content().value());
                    markdown.append(NEW_LINE);
                } else if (title != null) {
                    if (!title.startsWith("# ")) {
                        markdown.append("# ");
                    }
                    markdown.append(title);
                    markdown.append(NEW_LINE);
                    if (documentation != null) {
                        markdown.append(Exporter.cleanupMarkdownString(documentationItem.content().value()));
                        markdown.append(NEW_LINE);
                    }
                }
            });
        }
        if (markdown.length() != 0) {
            info.setDescription(markdown.toString());
        } else {
            info.setDescription(NO_DESCRIPTION_AVAILABLE);
            log.warn("No description available.");
        }
        return info;
    }

    private boolean isNotBlank(AnnotableStringType annotableStringType) {
        return annotableStringType != null && StringUtils.isNotBlank((CharSequence)annotableStringType.value());
    }

    private List<Tag> setupTags(Api ramlApi) {
        String title = ramlApi.title().value().toLowerCase(Locale.ROOT);
        return Collections.singletonList(new Tag().name(title));
    }

    protected static String cleanupMarkdownString(String value) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] lines = value.split(NEW_LINE);
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0 && lines[i].startsWith("#")) {
                String title = "# " + StringUtils.substringAfterLast((String)lines[i], (String)"#").trim();
                stringBuilder.append(title).append(NEW_LINE);
                continue;
            }
            stringBuilder.append(lines[i]).append(NEW_LINE);
        }
        return stringBuilder.toString().trim();
    }

    private void parseRamlTypeReferences(URL baseUrl, Map<String, String> ramlTypeReferences, JsonNode jsonNode) {
        if (jsonNode.hasNonNull("types")) {
            ObjectNode types = (ObjectNode)jsonNode.get("types");
            types.fields().forEachRemaining(nodeEntry -> this.parseRamlRefEntry(baseUrl, ramlTypeReferences, (Map.Entry<String, JsonNode>)nodeEntry));
        }
        if (jsonNode.hasNonNull("schemas")) {
            ObjectNode schemas = (ObjectNode)jsonNode.get("schemas");
            schemas.fields().forEachRemaining(nodeEntry -> this.parseRamlRefEntry(baseUrl, ramlTypeReferences, (Map.Entry<String, JsonNode>)nodeEntry));
        }
        if (jsonNode.hasNonNull("uses")) {
            ObjectNode traits = (ObjectNode)jsonNode.get("uses");
            traits.fields().forEachRemaining(traitMap -> {
                String traitRef = ((JsonNode)traitMap.getValue()).textValue();
                log.debug("Parsing trait ref: {}", (Object)traitRef);
                try {
                    URL absoluteReference = Utils.getAbsoluteReference(baseUrl, traitRef);
                    URL absoluteReferenceParent = Utils.getAbsoluteReferenceParent(absoluteReference);
                    JsonNode trait = mapper.readTree(absoluteReference);
                    this.parseRamlTypeReferences(absoluteReferenceParent, ramlTypeReferences, trait);
                }
                catch (IOException e) {
                    log.error("Failed ot read url: {}", (Object)traitRef, (Object)e);
                }
            });
        }
    }

    private void parseRamlRefEntry(URL baseUrl, Map<String, String> ramlTypeReferences, Map.Entry<String, JsonNode> nodeEntry) {
        String key = nodeEntry.getKey();
        JsonNode typeReference = nodeEntry.getValue();
        if (typeReference.has("type") && typeReference instanceof ObjectNode) {
            JsonNode typeNode = typeReference.get("type");
            String url = typeNode.textValue();
            if (typeNode instanceof TextNode && Utils.isUrl(url)) {
                URL absoluteReference = Utils.getAbsoluteReference(baseUrl, url);
                ramlTypeReferences.put(key, absoluteReference.toString());
                log.debug("Add raml type reference: {} to: {}", (Object)key, (Object)absoluteReference);
            } else {
                log.debug("Cannot create raml ref for: {}", (Object)url);
            }
        } else if (typeReference instanceof TextNode && typeReference.textValue().endsWith(".json")) {
            URL absoluteReference = Utils.getAbsoluteReference(baseUrl, typeReference.textValue());
            ramlTypeReferences.put(key, absoluteReference.toString());
            log.debug("Add raml type reference: {} to: {}", (Object)key, (Object)absoluteReference);
        }
    }

    private Map<String, TypeDeclaration> collectTypesFromRamlSpec(Api ramlApi) {
        TreeMap<String, TypeDeclaration> types = new TreeMap<String, TypeDeclaration>();
        for (Library library : ramlApi.uses()) {
            library.schemas().forEach(typeDeclaration -> types.put(typeDeclaration.name(), (TypeDeclaration)typeDeclaration));
            library.types().forEach(typeDeclaration -> types.put(typeDeclaration.name(), (TypeDeclaration)typeDeclaration));
        }
        ramlApi.schemas().forEach(typeDeclaration -> types.put(typeDeclaration.name(), (TypeDeclaration)typeDeclaration));
        ramlApi.types().forEach(typeDeclaration -> types.put(typeDeclaration.name(), (TypeDeclaration)typeDeclaration));
        return types;
    }

    private void validateRamlModelResult(File file, RamlModelResult ramlModelResult) throws ExportException {
        if (ramlModelResult.hasErrors()) {
            log.error("Error validating RAML document: {}", (Object)file);
            ramlModelResult.getValidationResults().forEach(validationResult -> log.error(validationResult.getMessage()));
            throw new ExportException("Error validation RAML");
        }
        if (ramlModelResult.getApiV10() == null) {
            throw new ExportException("Not a valid RAML 1.0 document");
        }
    }

    private void convertResources(String rootPath, List<Resource> resources, Paths paths, Components components, JsonSchemaToOpenApi jsonSchemaToOpenApi, List<Operation> operations) throws ExportException, DerefenceException {
        for (Resource resource : resources) {
            if (log.isDebugEnabled()) {
                log.debug("Mapping RAML Resource displayName: {} relativeUrl: {} with description: {} resourcePath: {}", new Object[]{resource.displayName().value(), resource.relativeUri().value(), resource.description() != null ? resource.description().value() : null, resource.resourcePath()});
            }
            PathItem pathItem = this.convertResource(resource, components, jsonSchemaToOpenApi, operations);
            String path = rootPath + resource.resourcePath();
            if (!pathItem.readOperations().isEmpty()) {
                paths.addPathItem(path, pathItem);
            }
            this.convertResources(rootPath, resource.resources(), paths, components, jsonSchemaToOpenApi, operations);
        }
    }

    private PathItem convertResource(Resource resource, Components components, JsonSchemaToOpenApi jsonSchemaToOpenApi, List<Operation> operations) throws ExportException, DerefenceException {
        PathItem pathItem = new PathItem();
        pathItem.summary(this.getDisplayName(resource.displayName()));
        pathItem.description(this.getDescription(resource));
        log.debug("Mapping RAML resource: {}", (Object)pathItem.getSummary());
        this.mapUriParameters(resource, pathItem, components);
        this.mapMethods(resource, pathItem, components, jsonSchemaToOpenApi, operations);
        return pathItem;
    }

    private void mapUriParameters(Resource resource, PathItem pathItem, Components components) {
        Resource current = resource;
        Resource parent = current.parentResource();
        while (parent != null) {
            current.uriParameters().forEach(type -> {
                log.debug("Mapping URI parameter: {}", (Object)type.name());
                this.log((TypeDeclaration)type);
                PathParameter parameter = new PathParameter();
                this.convertTypeToParameter((TypeDeclaration)type, (Parameter)parameter, components);
                if (pathItem.getParameters() != null && pathItem.getParameters().stream().anyMatch(arg_0 -> Exporter.lambda$mapUriParameters$15((Parameter)parameter, arg_0))) {
                    log.warn("{} has double Parameter {} in path: {} Detected. ignoring", new Object[]{resource.resourcePath(), parameter.getName(), pathItem.getDescription()});
                } else {
                    pathItem.addParametersItem((Parameter)parameter);
                }
            });
            current = parent = current.parentResource();
        }
        this.resolveUnspecifiedPathParameters(resource, pathItem);
    }

    private void resolveUnspecifiedPathParameters(Resource resource, PathItem pathItem) {
        String resourcePath = resource.resourcePath();
        Matcher matcher = placeholderPattern.matcher(resourcePath);
        while (matcher.find()) {
            Optional<Parameter> optionalParameter;
            String placeHolder = matcher.group();
            String placeholderName = placeHolder.substring(1, placeHolder.length() - 1);
            if (pathItem.getParameters() == null) {
                pathItem.setParameters(new ArrayList());
            }
            if ((optionalParameter = pathItem.getParameters().stream().filter(parameter -> parameter.getName().equals(placeholderName)).findFirst()).isPresent()) continue;
            log.debug("Unspecified URI parameter: {} in RAML. Generating URI Parameter in OpenAPI", (Object)placeholderName);
            PathParameter parameter2 = new PathParameter();
            parameter2.setName(placeholderName);
            parameter2.setRequired(Boolean.valueOf(true));
            parameter2.description("Generated parameter by BOAT. Please specify the URI parameter in RAML");
            parameter2.setSchema((Schema)new StringSchema());
            pathItem.addParametersItem((Parameter)parameter2);
        }
    }

    private void log(TypeDeclaration typeDeclaration) {
        String description = this.getDescription(typeDeclaration.description());
        if (log.isDebugEnabled()) {
            log.debug("Type name: {} type: {} displayName: {} defaultValue: {} description: {}", new Object[]{typeDeclaration.name(), typeDeclaration.type(), this.getDisplayName(typeDeclaration.displayName()), typeDeclaration.defaultValue(), description});
        }
    }

    private String getDisplayName(AnnotableStringType parameter) {
        return parameter != null ? parameter.value() : null;
    }

    private String getDescription(MarkdownString description) {
        if (description == null) {
            return NO_DESCRIPTION_AVAILABLE;
        }
        String result = description.value();
        return StringEscapeUtils.unescapeJavaScript((String)result);
    }

    private void mapMethods(Resource resource, PathItem pathItem, Components components, JsonSchemaToOpenApi jsonSchemaToOpenApi, List<Operation> operations) throws ExportException, DerefenceException {
        for (Method ramlMethod : resource.methods()) {
            PathItem.HttpMethod httpMethod = Exporter.getHttpMethod(ramlMethod);
            ApiResponses apiResponses = this.mapResponses(resource, ramlMethod, components, jsonSchemaToOpenApi);
            log.debug("Mapping method: {}", (Object)httpMethod);
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            this.addHeaders(ramlMethod, parameters, components);
            this.addQueryParameters(ramlMethod, parameters, components);
            RequestBody requestBody = this.convertRequestBody(resource, ramlMethod, components, jsonSchemaToOpenApi);
            String resourcePath = resource.resourcePath();
            String tag = Arrays.stream(resourcePath.substring(1).split("/")).findFirst().orElse("tag");
            String operationId = this.getOperationId(resource, ramlMethod, operations, requestBody);
            String description = this.getDescription(ramlMethod.description());
            ArrayList<String> unwantedSummaries = new ArrayList<String>(Arrays.asList("put", "get", "post", "delete"));
            String summary = ramlMethod.displayName() == null || unwantedSummaries.contains(ramlMethod.displayName().value()) ? this.getSummary(ramlMethod.description()) : ramlMethod.displayName().value();
            Operation operation = new Operation();
            operation.addTagsItem(tag);
            operation.setDescription(description);
            operation.setResponses(apiResponses);
            operation.setSummary(summary);
            operation.setParameters(parameters.isEmpty() ? null : parameters);
            operation.setOperationId(operationId);
            operations.add(operation);
            if (httpMethod.equals((Object)PathItem.HttpMethod.DELETE) && requestBody != null) {
                log.warn("{} is a DELETE operation and must NOT have an requestBody. Removing operation entirely", (Object)resourcePath);
            } else {
                operation.setRequestBody(requestBody);
            }
            this.processMethodAnnotations(resourcePath, components, ramlMethod, httpMethod, operation, jsonSchemaToOpenApi);
            if (description != null && description.contains("deprecated")) {
                operation.deprecated(Boolean.valueOf(true));
            }
            pathItem.operation(httpMethod, operation);
        }
    }

    private String getSummary(MarkdownString description) {
        if (description == null) {
            return null;
        }
        return Stream.of(description.value().split(NEW_LINE)).findFirst().map(firstLine -> firstLine.replace("#", "")).map(String::trim).map(firstLine -> firstLine.endsWith(".") ? firstLine : firstLine + ".").orElse(null);
    }

    private String getOperationId(Resource resource, Method ramlMethod, List<Operation> operations, RequestBody requestBody) {
        String operationId;
        String httpMethod = ramlMethod.method();
        String resourceName = resource.displayName().value();
        if (resourceName.contains("/")) {
            resourceName = Arrays.stream(resourceName.split("/")).map(StringUtils::capitalize).collect(Collectors.joining());
        }
        if ((operationId = httpMethod + resourceName).equalsIgnoreCase(ramlMethod.method())) {
            operationId = Utils.normalizeDisplayName(StringUtils.substringAfterLast((String)resource.resourcePath(), (String)"/"));
        }
        if (operationId.contains(" ")) {
            operationId = Arrays.stream(operationId.split(" ")).map(StringUtils::capitalize).collect(Collectors.joining());
        }
        operationId = Utils.normalizeDisplayName(operationId);
        operationId = (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)operationId);
        String finalOperationId = operationId;
        if (this.operationIdExists(operations, finalOperationId) && requestBody != null) {
            Set<String> placeHolders = Utils.getPlaceholders(resource.resourcePath());
            if (!placeHolders.isEmpty()) {
                String suffix = "By" + placeHolders.stream().map(StringUtils::capitalize).collect(Collectors.joining("And"));
                if (!operationId.toLowerCase().endsWith(suffix.toLowerCase())) {
                    operationId = operationId + suffix;
                }
            }
            if (log.isWarnEnabled()) {
                log.warn("Operation {} for path: {}  already exists! using: {}", new Object[]{finalOperationId, resource.resourcePath(), operationId});
            }
        }
        if (this.operationIdExists(operations, finalOperationId)) {
            operationId = operationId + httpMethod + StringUtils.capitalize((String)Utils.normalizeDisplayName(resourceName));
        }
        if (log.isDebugEnabled()) {
            log.debug("Resolve operationId: {} from resource: {} with method: {} and path: {}", new Object[]{operationId, resource.displayName().value(), httpMethod, resource.resourcePath()});
        }
        return operationId;
    }

    private boolean operationIdExists(List<Operation> operations, String finalOperationId) {
        return operations.stream().anyMatch(operation -> operation.getOperationId().equalsIgnoreCase(finalOperationId));
    }

    private void processMethodAnnotations(String resourcePath, Components components, Method ramlMethod, PathItem.HttpMethod httpMethod, Operation operation, JsonSchemaToOpenApi jsonSchemaToOpenApi) throws ExportException {
        for (AnnotationRef annotationRef : ramlMethod.annotations()) {
            TypeDeclaration annotation = annotationRef.annotation();
            TypeInstance typeInstance = annotationRef.structuredValue();
            Schema annotationSchema = this.getAnnotationSchema(resourcePath, components, annotation, jsonSchemaToOpenApi);
            if (annotation.name().toLowerCase().contains("deprecat")) {
                log.debug("Operation {} in path: {} marked deprecated", (Object)httpMethod, (Object)resourcePath);
                operation.deprecated(Boolean.valueOf(true));
            }
            for (TypeInstanceProperty property : typeInstance.properties()) {
                String extensionName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, annotationSchema.getName());
                String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, property.name());
                if (property.isArray().booleanValue()) {
                    operation.addExtension("-" + extensionName + "-" + propertyName, (Object)property.values());
                    continue;
                }
                operation.addExtension("x-" + extensionName + "-" + propertyName, property.value().value());
            }
        }
    }

    private Schema getAnnotationSchema(String resourcePath, Components components, TypeDeclaration annotation, JsonSchemaToOpenApi jsonSchemaToOpenApi) throws ExportException {
        Schema annotationSchema;
        if (annotation instanceof JSONTypeDeclaration) {
            JSONTypeDeclaration jsonType = (JSONTypeDeclaration)annotation;
            if (jsonType.type().equals(jsonType.schemaContent())) {
                try {
                    annotationSchema = jsonSchemaToOpenApi.convert(annotation.name(), jsonType);
                    jsonSchemaToOpenApi.dereferenceSchema(annotationSchema, components);
                }
                catch (DerefenceException e) {
                    throw new ExportException("Cannot dereference inline schema: : " + jsonType.schemaContent() + " for response: " + resourcePath);
                }
                Utils.cleanUp(annotationSchema, !this.exporterOptions.isAddJavaTypeExtensions());
            } else {
                String modelName = Utils.getProposedSchemaName(jsonType.type());
                annotationSchema = (Schema)components.getSchemas().get(modelName);
                if (annotationSchema == null) {
                    throw new ExportException("Cannot find schema definition for: " + jsonType.type() + " for response: " + resourcePath);
                }
            }
        } else {
            annotationSchema = RamlSchemaToOpenApi.convert(annotation.name(), annotation, components);
        }
        return annotationSchema;
    }

    private RequestBody convertRequestBody(Resource resource, Method ramlMethod, Components components, JsonSchemaToOpenApi jsonSchemaToOpenApi) throws DerefenceException, ExportException {
        if (ramlMethod.body() == null || ramlMethod.body().isEmpty()) {
            return null;
        }
        Content content = new Content();
        for (TypeDeclaration body : ramlMethod.body()) {
            String name = this.getName(resource, ramlMethod) + "Request";
            MediaType mediaType = this.convertBody(body, name, components, jsonSchemaToOpenApi);
            content.addMediaType(body.name(), mediaType);
        }
        RequestBody requestBody = new RequestBody();
        requestBody.setContent(content);
        requestBody.setDescription(ramlMethod.description() != null ? this.getDescription(ramlMethod.description()) : null);
        return requestBody;
    }

    private void addQueryParameters(Method ramlMethod, ArrayList<Parameter> parameters, Components components) {
        ramlMethod.queryParameters().forEach(typeDeclaration -> {
            QueryParameter parameter = new QueryParameter();
            this.convertTypeToParameter((TypeDeclaration)typeDeclaration, (Parameter)parameter, components);
            parameters.add((Parameter)parameter);
        });
    }

    private void addHeaders(Method ramlMethod, ArrayList<Parameter> parameters, Components components) {
        ramlMethod.headers().forEach(type -> {
            HeaderParameter parameter = new HeaderParameter();
            this.convertTypeToParameter((TypeDeclaration)type, (Parameter)parameter, components);
            parameters.add((Parameter)parameter);
        });
    }

    private void convertTypeToParameter(TypeDeclaration typeDeclaration, Parameter parameter, Components components) {
        if (log.isDebugEnabled()) {
            log.debug("Converting Parameter from: {} with type: {} into: {}", new Object[]{typeDeclaration.name(), typeDeclaration.type(), parameter.getClass().getName()});
        }
        Schema schema = RamlSchemaToOpenApi.convert(typeDeclaration.name(), typeDeclaration, components);
        parameter.setName(typeDeclaration.name());
        parameter.setRequired(typeDeclaration.required());
        parameter.setSchema(schema);
        if (Boolean.TRUE.equals(schema.getDeprecated())) {
            parameter.deprecated(Boolean.valueOf(true));
        }
        parameter.setDescription(this.getDescription(typeDeclaration.description()));
        if (typeDeclaration.examples() != null && !typeDeclaration.examples().isEmpty()) {
            parameter.setExamples(new LinkedHashMap());
            typeDeclaration.examples().forEach(exampleSpec -> {
                Example example = new Example();
                example.setValue(ExampleUtils.getExampleObject(exampleSpec, true));
                example.setSummary(exampleSpec.name());
                parameter.getExamples().put(exampleSpec.name(), example);
            });
        } else {
            parameter.setExamples(new LinkedHashMap());
            Example example = new Example();
            example.setValue(ExampleUtils.getExampleObject(typeDeclaration.example(), true));
            example.setSummary(EXAMPLE);
            parameter.getExamples().put(EXAMPLE, example);
        }
    }

    private ApiResponses mapResponses(Resource resource, Method ramlMethod, Components components, JsonSchemaToOpenApi jsonSchemaToOpenApi) throws ExportException, DerefenceException {
        ApiResponses apiResponses = new ApiResponses();
        for (Response ramlResponse : ramlMethod.responses()) {
            Content apiResponseContent = new Content();
            String responseCode = ramlResponse.code().value();
            String description = this.getDescription(ramlResponse);
            ApiResponse apiResponse = new ApiResponse();
            apiResponse.setDescription(description);
            if (!responseCode.equals("204")) {
                List bodies = ramlResponse.body();
                for (TypeDeclaration body : bodies) {
                    String contentType = body.name();
                    if (!"application/json".equals(contentType) && !"body".equals(contentType)) continue;
                    String name = this.getName(resource, ramlMethod) + StringUtils.capitalize((String)ramlMethod.method()) + "ResponseBody";
                    MediaType mediaType = this.convertBody(body, name, components, jsonSchemaToOpenApi);
                    apiResponseContent.addMediaType(contentType, mediaType);
                }
                apiResponse.setContent(apiResponseContent);
            }
            apiResponses.addApiResponse(responseCode, apiResponse);
        }
        return apiResponses;
    }

    private MediaType convertBody(TypeDeclaration body, String name, Components components, JsonSchemaToOpenApi jsonSchemaToOpenApi) throws ExportException, DerefenceException {
        Schema bodySchema = null;
        MediaType mediaType = null;
        if (body instanceof JSONTypeDeclaration) {
            mediaType = new MediaType();
            JSONTypeDeclaration jsonType = (JSONTypeDeclaration)body;
            String type = jsonType.type();
            if (type.equals(jsonType.schemaContent())) {
                bodySchema = (Schema)components.getSchemas().get(name);
                if (bodySchema == null) {
                    bodySchema = jsonSchemaToOpenApi.convert(name, jsonType);
                    jsonSchemaToOpenApi.dereferenceSchema(bodySchema, components);
                    mediaType.setSchema(bodySchema);
                    Utils.cleanUp(bodySchema, !this.exporterOptions.isAddJavaTypeExtensions());
                }
                mediaType.setSchema(new Schema().$ref(name));
            } else {
                String schemaName = Utils.getProposedSchemaName(type);
                bodySchema = (Schema)components.getSchemas().get(schemaName);
                if (bodySchema == null) {
                    log.error("No Schema with the name: {} resolved from: {} is present: ", (Object)schemaName, (Object)type);
                    throw new ExportException("Invalid Schema");
                }
                mediaType.setSchema(new Schema().$ref(schemaName));
            }
        } else if (body instanceof XMLTypeDeclaration) {
            log.debug("No OpenAPI  schema for: {} ", (Object)name);
        } else {
            bodySchema = RamlSchemaToOpenApi.convert(name, body, components);
            mediaType = new MediaType();
            mediaType.setSchema(bodySchema);
        }
        if (mediaType != null) {
            this.convertExamples(body, mediaType);
            if (bodySchema.getExtensions() != null && bodySchema.getExtensions().containsKey(X_EXAMPLES)) {
                List examples = (List)bodySchema.getExtensions().get(X_EXAMPLES);
                for (Example example : examples) {
                    mediaType.addExamples(example.getSummary(), example);
                }
                mediaType.setExample(null);
            }
        }
        return mediaType;
    }

    private void convertExamples(TypeDeclaration body, MediaType mediaType) {
        if (body.examples() != null && !body.examples().isEmpty()) {
            body.examples().forEach(exampleSpec -> {
                Example example = new Example();
                example.setValue(ExampleUtils.getExampleObject(exampleSpec, this.exporterOptions.isConvertExamplesToYaml()));
                example.setSummary(exampleSpec.name());
                mediaType.addExamples(exampleSpec.name(), example);
                mediaType.setExample(null);
            });
        } else {
            Object exampleObject = ExampleUtils.getExampleObject(body.example(), this.exporterOptions.isConvertExamplesToYaml());
            if (exampleObject != null) {
                Example example = new Example();
                example.setValue(exampleObject);
                mediaType.addExamples(EXAMPLE, example);
                mediaType.setExample(null);
            }
        }
    }

    private String getName(Resource resource, Method ramlMethod) {
        String value;
        AnnotableStringType annotableStringType = resource.displayName();
        if (annotableStringType != null && !(value = annotableStringType.value()).contains("{") && !value.startsWith("/")) {
            return Utils.normalizeSchemaName(value);
        }
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(resource.resourcePath().split("/")));
        parts.add(ramlMethod.method());
        return parts.stream().filter(StringUtils::isNotEmpty).map(Exporter::replacePlaceHolder).map(StringUtils::capitalize).collect(Collectors.joining());
    }

    private static String replacePlaceHolder(String part) {
        if (part.contains("{")) {
            return "ById";
        }
        return part;
    }

    private String getDescription(Response ramlResponse) {
        String description = this.getDescription(ramlResponse.description());
        if (description == null) {
            description = "Automagically created by RAML to Open API Exporter. Update RAML to include proper description for each response!";
        }
        return description;
    }

    private String getDescription(Resource resource) {
        String description = this.getDescription(resource.description());
        if (description == null) {
            return "Generated description for " + resource.displayName().value() + ". Please update RAML spec to provide description for this resource";
        }
        return description;
    }

    private static PathItem.HttpMethod getHttpMethod(Method ramlMethod) {
        return PathItem.HttpMethod.valueOf((String)ramlMethod.method().toUpperCase());
    }

    private static /* synthetic */ boolean lambda$mapUriParameters$15(Parameter parameter, Parameter existingParam) {
        return existingParam.getName().equals(parameter.getName()) && existingParam.getIn().equals(parameter.getIn());
    }
}

