/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.DerefenceException;
import com.backbase.oss.boat.ExampleUtils;
import com.backbase.oss.boat.ExportException;
import com.backbase.oss.boat.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonSchemaToOpenApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaToOpenApi.class);
    private static final String EXTENDS = "extends";
    public static final String X_RAML_TYPE = "x-raml-type";
    public static final String X_RAML_BASE = "x-raml-base";
    public static final String X_RAML_PARENT = "x-raml-parent";
    public static final String X_RAML_EXTENDS = "x-raml-extends";
    public static final String X_JAVA_TYPE = "x-java-type";
    public static final String JAVA_TYPE = "javaType";
    public static final String PROPERTIES = "properties";
    public static final String JAVA_ENUM_NAMES = "javaEnumNames";
    public static final String X_JAVA_ENUM_NAMES = "x-java-enum-names";
    public static final String STRING = "string";
    public static final String FORMAT = "format";
    public static final String TYPE = "type";
    public static final String NUMBER = "number";
    public static final String DATE_TIME = "date-time";
    public static final String REQUIRED = "required";
    public static final String DATETIME_ONLY = "datetime-only";
    public static final String DATETIME = "datetime";
    public static final String DATE = "date";
    public static final String DATE_ONLY = "date-only";
    public static final String DOLLAR_REF = "$ref";
    private final URL baseUrl;
    private final Components components;
    private final Map<String, String> ramlTypeReferences;
    private final Map<String, JsonNode> jsonSchemas;
    private final BiMap<String, String> referenceNames;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonSchemaToOpenApi(URL baseUrl, Components components, Map<String, String> ramlTypeReferences) {
        this.baseUrl = baseUrl;
        this.components = components;
        this.jsonSchemas = new TreeMap<String, JsonNode>();
        this.referenceNames = HashBiMap.create();
        this.ramlTypeReferences = ramlTypeReferences;
    }

    public Schema convert(String name, JSONTypeDeclaration typeDeclaration) throws ExportException {
        Schema schema;
        log.debug("Converting JSONTypeDeclaration: {}", (Object)name);
        String ramlRef = this.ramlTypeReferences.get(name);
        String type = typeDeclaration.type();
        String schemaName = Utils.normalizeSchemaName(name);
        try {
            if (ramlRef != null) {
                URL referenceParent = Utils.getAbsoluteReferenceParent(ramlRef);
                schema = (Schema)this.components.getSchemas().get(schemaName);
                if (schema == null) {
                    JsonNode jsonSchema = this.objectMapper.readTree(type);
                    schema = Utils.resolveSchemaByJavaType(jsonSchema, this.components);
                    if (schema == null) {
                        schema = this.createNewSchema(null, jsonSchema, schemaName, this.components, referenceParent);
                        this.components.addSchemas(schemaName, schema);
                        log.debug("Created new schema from: {} as: {} with ramlRef: {}", new Object[]{name, schemaName, ramlRef});
                    } else {
                        log.debug("Used existing schema: {} resolved by javaType: {}", (Object)schemaName, schema.getExtensions().get(X_JAVA_TYPE));
                    }
                } else {
                    log.debug("Using existing schema: {}", (Object)schemaName);
                }
            } else {
                JsonNode jsonSchema = this.objectMapper.readTree(type);
                schema = Utils.resolveSchemaByJavaType(jsonSchema, this.components);
                if (schema == null) {
                    String referenceName = this.baseUrl.toString() + "/" + name + ".raml";
                    this.referenceNames.put((Object)referenceName, (Object)name);
                    schema = this.createNewSchema(null, jsonSchema, name, this.components, this.baseUrl);
                    schema.setExample(ExampleUtils.getExampleObject(typeDeclaration.example(), true));
                    this.components.addSchemas(name, schema);
                }
                log.debug("Created new schema from: {} as: {}", (Object)name, (Object)schemaName);
                this.components.addSchemas(schemaName, schema);
            }
        }
        catch (IOException e) {
            throw new ExportException("Cannot read json schema from type: " + typeDeclaration.name(), e);
        }
        catch (DerefenceException e) {
            throw new ExportException("Cannot dereference json schema from type: " + typeDeclaration.name(), e);
        }
        catch (RuntimeException e) {
            throw new ExportException("Runtime exception:", e);
        }
        schema.setExample(ExampleUtils.getExampleObject(typeDeclaration.example(), true));
        return schema;
    }

    public Schema createNewSchema(Schema parent, JsonNode type, String name, Components components, URL baseUrl) throws DerefenceException {
        String jsonSchemaType;
        log.debug("Creating Schema for: {} with path: {}", (Object)name, (Object)baseUrl);
        if (name.contains(" ")) {
            throw new IllegalStateException("name cannot contain spaces");
        }
        Schema schema = Utils.resolveSchemaByJavaType(type, components);
        if (schema != null) {
            return schema;
        }
        switch (jsonSchemaType = this.determineJsonSchemaType(type)) {
            case "date-time": 
            case "datetime-only": 
            case "datetime": {
                schema = new DateTimeSchema();
                break;
            }
            case "date": 
            case "date-only": {
                schema = new DateSchema();
                break;
            }
            case "object": {
                if (type.get(EXTENDS) != null) {
                    String extendedSchemaName;
                    schema = new ComposedSchema();
                    JsonNode extendsNode = type.get(EXTENDS);
                    if (this.hasReference(extendsNode)) {
                        Schema extendedSchema;
                        String extendsReference = extendsNode.get(DOLLAR_REF).asText();
                        log.debug("Creating Composed Schema for {} with reference: {}", (Object)name, (Object)extendsReference);
                        URL absoluteReference = this.resolveAbsoluteReference(parent, extendsReference, baseUrl);
                        URL absoluteReferenceParent = Utils.getAbsoluteReferenceParent(absoluteReference);
                        JsonNode dereferencedExtendedNode = this.getJsonNode(absoluteReference);
                        JsonNode dereferenced = this.getJsonNode(absoluteReference);
                        extendedSchemaName = Utils.getSchemaNameFromJavaClass(dereferenced).orElse(Utils.getSchemaNameFromReference(absoluteReference, schema.getName(), this.referenceNames));
                        if (extendedSchemaName.equals(name)) {
                            extendedSchemaName = extendedSchemaName + "Parent";
                        }
                        if ((extendedSchema = (Schema)components.getSchemas().get(extendedSchemaName)) == null) {
                            log.debug("Creating new schema for extended reference: {} with: {}", (Object)absoluteReference, (Object)absoluteReferenceParent);
                            extendedSchema = this.createNewSchema(parent, dereferencedExtendedNode, extendedSchemaName, components, absoluteReferenceParent);
                            components.addSchemas(extendedSchemaName, extendedSchema);
                            schema.addExtension(X_RAML_EXTENDS, (Object)extendedSchema);
                        } else {
                            log.debug("Using existing schema: {}", (Object)extendedSchema.getName());
                        }
                    } else {
                        extendedSchemaName = name + "Parent";
                        Schema extendedSchema = (Schema)components.getSchemas().get(extendedSchemaName);
                        if (extendedSchema == null) {
                            extendedSchema = this.createNewSchema(parent, extendsNode, extendedSchemaName, components, baseUrl);
                            components.addSchemas(extendedSchemaName, extendedSchema);
                        }
                    }
                    ((ComposedSchema)schema).setAllOf(Collections.singletonList(new ObjectSchema().$ref(extendedSchemaName)));
                    break;
                }
                schema = new ObjectSchema();
                break;
            }
            case "string": 
            case "time-only": {
                schema = new StringSchema();
                break;
            }
            case "email": {
                schema = new EmailSchema();
                break;
            }
            case "number": {
                schema = new NumberSchema();
                break;
            }
            case "integer": {
                schema = new IntegerSchema();
                break;
            }
            case "boolean": {
                schema = new BooleanSchema();
                break;
            }
            case "array": {
                schema = new ArraySchema();
                JsonNode itemJsonSchema = type.get("items");
                if (this.hasReference(itemJsonSchema)) {
                    String absoluteReference;
                    String itemReference = itemJsonSchema.get(DOLLAR_REF).textValue();
                    if (StringUtils.isNotEmpty((CharSequence)itemReference) && !Utils.isUrl(itemReference) && !Utils.isFragment(itemReference)) {
                        absoluteReference = Utils.getAbsoluteReference(baseUrl, itemReference).toString();
                    } else if (Utils.isFragment(itemReference) && Utils.isDirectory(baseUrl, itemReference)) {
                        absoluteReference = this.getReferenceFromParent(itemReference, parent);
                        absoluteReference = absoluteReference + itemReference;
                    } else {
                        absoluteReference = itemReference;
                    }
                    if (!absoluteReference.equals(itemReference)) {
                        itemJsonSchema = ((ObjectNode)itemJsonSchema).set(DOLLAR_REF, (JsonNode)new TextNode(absoluteReference));
                    }
                    Schema itemSchema = this.mapProperty(parent, components, name + "Item", (ObjectNode)itemJsonSchema, baseUrl, false);
                    ((ArraySchema)schema).setItems(itemSchema);
                    break;
                }
                Schema itemSchema = this.mapProperty(parent, components, name + "Item", (ObjectNode)itemJsonSchema, baseUrl, false);
                ((ArraySchema)schema).setItems(itemSchema);
                break;
            }
            case "anyOf": {
                schema = new ComposedSchema();
                ArrayNode anyOfJsonSchmema = (ArrayNode)type.get(TYPE);
                Iterable iterable = () -> ((ArrayNode)anyOfJsonSchmema).elements();
                Stream<JsonNode> stream = StreamSupport.stream(iterable.spliterator(), false);
                List anyOfSchemas = stream.map(jsonNode -> new Schema().type(jsonNode.textValue())).collect(Collectors.toList());
                ((ComposedSchema)schema).setAnyOf(anyOfSchemas);
                break;
            }
            default: {
                schema = new StringSchema();
            }
        }
        schema.addExtension(X_RAML_BASE, (Object)baseUrl);
        schema.addExtension(X_RAML_TYPE, (Object)type);
        schema.addExtension(X_RAML_PARENT, (Object)parent);
        schema.setName(name);
        schema.setTitle(this.getString(type, "title"));
        schema.setMinLength(this.getInteger(type, "minLength"));
        schema.setMaxLength(this.getInteger(type, "maxLength"));
        schema.setPattern(this.getString(type, "pattern"));
        schema.setMinimum(this.getBigDecimal(type, "minimum"));
        schema.setMaximum(this.getBigDecimal(type, "maximum"));
        String description = this.getString(type, "description");
        schema.setDescription(description);
        if (description != null && (description.contains("deprecated") || description.contains("@deprecated"))) {
            schema.setDeprecated(Boolean.valueOf(true));
        }
        Map<String, Schema> properties = this.getProperties(schema, type, components, baseUrl);
        if (schema.getProperties() == null) {
            schema.setProperties(properties);
        } else if (properties != null && properties.size() > 0) {
            schema.getProperties().putAll(properties);
        }
        this.getRequired(type).ifPresent(arg_0 -> ((Schema)schema).setRequired(arg_0));
        String ref = this.getString(type, DOLLAR_REF);
        if (StringUtils.isNotEmpty((CharSequence)ref) && !Utils.isUrl(ref) && !Utils.isFragment(ref)) {
            ref = Utils.getAbsoluteReference(baseUrl, ref).toString();
        } else if (StringUtils.isNotEmpty((CharSequence)ref) && Utils.isFragment(ref) && Utils.isDirectory(baseUrl, ref)) {
            ref = this.getReferenceFromParent(ref, parent);
        }
        schema.set$ref(ref);
        if (type.hasNonNull(JAVA_TYPE)) {
            schema.addExtension(X_JAVA_TYPE, (Object)type.get(JAVA_TYPE).textValue());
        }
        if (type.hasNonNull(JAVA_ENUM_NAMES)) {
            schema.addExtension(X_JAVA_ENUM_NAMES, this.getEnum(type, JAVA_ENUM_NAMES));
        }
        this.getEnum(type).ifPresent(arg_0 -> ((Schema)schema).setEnum(arg_0));
        return schema;
    }

    private URL resolveAbsoluteReference(Schema parent, String ref, URL baseUrl) {
        if (StringUtils.isNotEmpty((CharSequence)ref) && !Utils.isUrl(ref) && !Utils.isFragment(ref)) {
            return Utils.getAbsoluteReference(baseUrl, ref);
        }
        if (Utils.isFragment(ref) && Utils.isDirectory(baseUrl, ref)) {
            String referenceFromParent = this.getReferenceFromParent(ref, parent);
            if (referenceFromParent == null) {
                throw new IllegalStateException("Whha??");
            }
            return new URL(referenceFromParent);
        }
        if (Utils.isFragment(ref) && Utils.hasFragment(baseUrl.toString())) {
            String base = StringUtils.substringBefore((String)baseUrl.toString(), (String)"#");
            return new URL(base + ref);
        }
        return new URL(ref);
    }

    private boolean hasReference(JsonNode itemJsonSchema) {
        return itemJsonSchema.hasNonNull(DOLLAR_REF);
    }

    private String determineJsonSchemaType(JsonNode type) {
        assert (type != null);
        JsonNode jsonType = type.get(TYPE);
        if (jsonType != null && jsonType.isTextual() && !type.has(FORMAT)) {
            return this.determineTypeFromJavaType(type, jsonType.asText());
        }
        if (jsonType != null && type.has(FORMAT)) {
            return type.get(FORMAT).textValue();
        }
        if (jsonType != null && jsonType.isArray()) {
            return "anyOf";
        }
        if (type.hasNonNull("enum")) {
            return STRING;
        }
        if (type.hasNonNull(JAVA_TYPE) || type.hasNonNull(DOLLAR_REF)) {
            return "object";
        }
        if (type instanceof ObjectNode && ((ObjectNode)type).size() == 0) {
            return STRING;
        }
        log.error("Cannot determine json type from: {}. Guessing string", (Object)type);
        return STRING;
    }

    private String determineTypeFromJavaType(JsonNode type, String fallback) {
        if (type.hasNonNull(JAVA_TYPE)) {
            String javaType;
            switch (javaType = type.get(JAVA_TYPE).textValue()) {
                case "java.util.Date": {
                    Optional<Object> format = Optional.ofNullable(type.hasNonNull(FORMAT) ? type.get(FORMAT).textValue() : null);
                    return format.orElseGet(() -> DATE_TIME);
                }
                case "java.lang.Long": {
                    return NUMBER;
                }
            }
            return fallback;
        }
        return fallback;
    }

    private Optional<List> getEnum(JsonNode type) {
        String propertyName = "enum";
        return this.getEnum(type, propertyName);
    }

    private Optional<List> getEnum(JsonNode type, String propertyName) {
        if (type.hasNonNull(propertyName)) {
            JsonNode enumList = type.get(propertyName);
            ArrayList result = new ArrayList();
            ArrayNode arrayNode = (ArrayNode)enumList;
            arrayNode.forEach(jsonNode -> {
                if (jsonNode.isTextual()) {
                    result.add(jsonNode.textValue());
                } else if (jsonNode.isInt()) {
                    result.add(jsonNode.intValue());
                } else if (jsonNode.isBigDecimal()) {
                    result.add(jsonNode.decimalValue());
                } else {
                    throw new UnsupportedOperationException("Haven't come across type enum type: " + type);
                }
            });
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Map<String, Schema> getProperties(Schema parent, JsonNode type, Components components, URL baseUrl) throws DerefenceException {
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        if (type.hasNonNull(PROPERTIES)) {
            Iterator fields = type.get(PROPERTIES).fields();
            ArrayList fieldList = new ArrayList();
            fields.forEachRemaining(fieldList::add);
            for (Map.Entry field : fieldList) {
                JsonNode property = (JsonNode)field.getValue();
                Schema schema = this.mapProperty(parent, components, (String)field.getKey(), (ObjectNode)property, baseUrl, false);
                properties.put((String)field.getKey(), schema);
            }
        }
        if (properties.isEmpty()) {
            return null;
        }
        return properties;
    }

    private Schema mapProperty(Schema parent, Components components, String propertyName, ObjectNode jsonSchema, URL baseUrl, boolean derefence) throws DerefenceException {
        Schema schema;
        boolean hasJsonRef;
        boolean bl = hasJsonRef = jsonSchema.has(DOLLAR_REF) && StringUtils.isNotEmpty((CharSequence)jsonSchema.get(DOLLAR_REF).textValue());
        if (hasJsonRef && !derefence) {
            String reference = jsonSchema.get(DOLLAR_REF).textValue();
            URL absoluteReference = Utils.getAbsoluteReference(baseUrl, reference);
            jsonSchema.set(DOLLAR_REF, (JsonNode)new TextNode(absoluteReference.toString()));
            schema = this.createNewSchema(parent, (JsonNode)jsonSchema, propertyName, components, baseUrl);
        } else if (hasJsonRef) {
            String absoluteReference = jsonSchema.get(DOLLAR_REF).textValue();
            log.debug("Dereference jsonSchema: {}", (Object)absoluteReference);
            JsonNode dereferencedJsonSchema = this.getJsonNode(absoluteReference);
            String schemaName = Utils.getSchemaNameFromJavaClass(dereferencedJsonSchema).orElse(Utils.getSchemaNameFromReference(absoluteReference, parent.getName(), this.referenceNames));
            if (components.getSchemas().containsKey(schemaName)) {
                schema = (Schema)components.getSchemas().get(schemaName);
            } else {
                schema = Utils.resolveSchemaByJavaType(dereferencedJsonSchema, components);
                if (schema == null) {
                    log.debug("Adding property {} schema to catalog as: {}", (Object)propertyName, (Object)schemaName);
                    schema = this.createNewSchema(parent, dereferencedJsonSchema, schemaName, components, Utils.getAbsoluteReferenceParent(absoluteReference));
                    components.addSchemas(schemaName, schema);
                    this.dereferenceSchema(schema, components);
                } else {
                    log.debug("Reusing schema: {} for property: {}", (Object)schema.getName(), (Object)propertyName);
                }
            }
            log.debug("Property referenced schema: {}", (Object)schema.getName());
        } else {
            schema = this.createNewSchema(parent, (JsonNode)jsonSchema, propertyName, components, baseUrl);
        }
        return schema;
    }

    private Optional<List<String>> getRequired(JsonNode type) {
        if (!type.hasNonNull(PROPERTIES)) {
            return Optional.empty();
        }
        ArrayList required = new ArrayList();
        type.get(PROPERTIES).fields().forEachRemaining(field -> {
            JsonNode property = (JsonNode)field.getValue();
            if (property.hasNonNull(REQUIRED) && property.get(REQUIRED).asBoolean()) {
                required.add((String)field.getKey());
            }
        });
        if (type.has(REQUIRED)) {
            JsonNode requiredNode = type.get(REQUIRED);
            if (requiredNode.isArray()) {
                requiredNode.elements().forEachRemaining(jsonNode -> required.add(jsonNode.asText()));
            } else {
                log.warn("wut?");
            }
        }
        return required.isEmpty() ? Optional.empty() : Optional.of(required);
    }

    private String getString(JsonNode result, String key) {
        return result.hasNonNull(key) ? result.get(key).textValue() : null;
    }

    private Integer getInteger(JsonNode result, String key) {
        return result.hasNonNull(key) ? Integer.valueOf(result.get(key).asInt()) : null;
    }

    private BigDecimal getBigDecimal(JsonNode result, String key) {
        if (result.hasNonNull(key) && result.get(key).isTextual()) {
            String val = result.get(key).textValue();
            try {
                return new BigDecimal(val);
            }
            catch (Exception e) {
                log.warn("Cannot convert: {} to Big Decimal", (Object)val);
            }
        }
        return null;
    }

    void dereferenceSchema(Schema schema, Components components) throws DerefenceException {
        String ref = schema.get$ref();
        if (ref != null && Utils.isAbsolute(ref)) {
            URL absoluteParentReference = Utils.getAbsoluteReferenceParent(ref);
            log.debug("ref: {}", (Object)ref);
            JsonNode dereferenced = this.getJsonNode(ref);
            String schemaName = Utils.getSchemaNameFromJavaClass(dereferenced).orElse(Utils.getSchemaNameFromReference(ref, schema.getName(), this.referenceNames));
            log.debug("Dereference schema: {} with ref: {}", (Object)schemaName, (Object)ref);
            Schema referencedSchema = Utils.resolveSchemaByJavaType(dereferenced, components);
            if (referencedSchema == null) {
                if (components.getSchemas().containsKey(schemaName)) {
                    referencedSchema = (Schema)components.getSchemas().get(schemaName);
                } else {
                    referencedSchema = this.createNewSchema(schema, dereferenced, schemaName, components, absoluteParentReference);
                    components.addSchemas(schemaName, referencedSchema);
                    if (this.hasReference(referencedSchema)) {
                        this.dereferenceSchema(referencedSchema, components);
                    }
                }
            }
            schema.$ref(referencedSchema.getName());
        }
        if (schema instanceof ArraySchema) {
            this.dereferenceArraySchema((ArraySchema)schema, components);
        }
        if (schema.getProperties() != null) {
            LinkedHashMap properties = new LinkedHashMap(schema.getProperties());
            for (Map.Entry entry : properties.entrySet()) {
                Schema value = (Schema)entry.getValue();
                value.addExtension(X_RAML_PARENT, (Object)schema);
                log.debug("Deference item property: {} from: {}", (Object)value.getName(), (Object)schema.getName());
                this.dereferenceSchema(value, components);
            }
        }
    }

    private JsonNode getJsonNode(URL reference) {
        log.debug("Getting json for: {}", (Object)reference);
        return this.getJsonNode(reference.toURI());
    }

    private JsonNode getJsonNode(String reference) {
        URI ref = new URI(reference);
        return this.getJsonNode(ref);
    }

    private JsonNode getJsonNode(URI ref) {
        if (this.jsonSchemas.containsKey(ref.toString())) {
            log.debug("Returning cached ref: {}", (Object)ref);
            return this.jsonSchemas.get(ref.toString());
        }
        log.debug("getJsonNode for: {}", (Object)ref);
        JsonNode dereferenced = this.objectMapper.readTree(ref.toURL());
        if (ref.getFragment() != null) {
            List fragments = Arrays.stream(ref.getFragment().split("/")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            for (String fragment : fragments) {
                dereferenced = dereferenced.get(fragment);
            }
        }
        this.jsonSchemas.put(ref.toString(), dereferenced);
        return dereferenced;
    }

    private String getReferenceFromParent(String reference, Schema schema) {
        Schema parentSchema = (Schema)schema.getExtensions().get(X_RAML_PARENT);
        while (parentSchema != null && parentSchema.getExtensions() != null) {
            String ref = parentSchema instanceof ArraySchema ? ((ArraySchema)parentSchema).getItems().get$ref() : parentSchema.get$ref();
            if (ref != null && !ref.equals(reference)) {
                return ref;
            }
            parentSchema = (Schema)parentSchema.getExtensions().get(X_RAML_PARENT);
        }
        return null;
    }

    private boolean hasReference(Schema schema) {
        if (schema.get$ref() != null) {
            return true;
        }
        if (schema instanceof ArraySchema && ((ArraySchema)schema).getItems().get$ref() != null) {
            return true;
        }
        if (schema.getProperties() != null && schema.getProperties().values().stream().anyMatch(property -> this.hasReference((Schema)property))) {
            return true;
        }
        return schema.getExtensions().containsKey(X_RAML_EXTENDS);
    }

    private void dereferenceArraySchema(ArraySchema schema, Components components) throws DerefenceException {
        Schema parent = schema.getItems();
        String reference = parent.get$ref();
        if (parent.getExtensions() != null && reference != null && Utils.isAbsolute(reference)) {
            Schema referencedSchema;
            JsonNode dereferenced = this.getJsonNode(reference);
            String schemaName = Utils.getSchemaNameFromJavaClass(dereferenced).orElse(Utils.getSchemaNameFromReference(reference, schema.getName(), this.referenceNames));
            if (schemaName.equals(schema.getName())) {
                schemaName = schemaName + "Item";
            }
            if (components.getSchemas().containsKey(schemaName)) {
                referencedSchema = (Schema)components.getSchemas().get(schemaName);
            } else {
                referencedSchema = Utils.resolveSchemaByJavaType(dereferenced, components);
                if (referencedSchema == null) {
                    referencedSchema = this.createNewSchema((Schema)schema, dereferenced, schemaName, components, Utils.getAbsoluteReferenceParent(reference));
                    components.addSchemas(schemaName, referencedSchema);
                    if (this.hasReference(referencedSchema)) {
                        this.dereferenceSchema(referencedSchema, components);
                    }
                }
            }
            schema.getItems().$ref(referencedSchema.getName());
        } else {
            this.dereferenceSchema(parent, components);
        }
    }
}

