/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.DerefenceException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.CaseFormat;
import com.google.common.collect.BiMap;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final String JAVA_TYPE = "javaType";

    private Utils() {
        throw new UnsupportedOperationException("private constructor");
    }

    static URL getAbsoluteReference(URL base, String ref) {
        URI uri = base.toURI().resolve(ref);
        log.trace("Resolved: {} from {} and {}", new Object[]{uri, base, ref});
        File file = new File(uri.toURL().getFile());
        if (!file.exists()) {
            throw new DerefenceException("File does not exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new DerefenceException("File is a directory" + file.getAbsolutePath());
        }
        return uri.normalize().toURL();
    }

    static boolean isDirectory(URL base, String ref) {
        URI uri = base.toURI().resolve(ref);
        File file = new File(uri.toURL().getFile());
        boolean directory = file.isDirectory();
        log.trace("isDirectory: {} $ref: {} = {}", new Object[]{base, ref, directory});
        return directory;
    }

    static boolean isFragment(String ref) {
        return ref.startsWith("#");
    }

    static boolean isAbsolute(String ref) {
        return new URI(ref).isAbsolute();
    }

    static boolean hasFragment(String ref) {
        return ref.contains("#");
    }

    static URL getAbsoluteReferenceParent(String absoluteReference) {
        return Utils.getAbsoluteReferenceParent(new URL(absoluteReference));
    }

    static URL getAbsoluteReferenceParent(URL absoluteReference) {
        URI uri = absoluteReference.toURI();
        if (uri.getFragment() != null) {
            return uri.toURL();
        }
        URI parent = uri.getPath().endsWith("/") ? uri.resolve("..") : uri.resolve(".");
        return parent.toURL();
    }

    static Schema resolveSchemaByJavaType(JsonNode type, Components components) {
        if (type.hasNonNull(JAVA_TYPE) && !type.get(JAVA_TYPE).textValue().startsWith("java")) {
            if (log.isDebugEnabled()) {
                log.debug("Resolving Schema Type from javaType: {}", (Object)type.get(JAVA_TYPE).textValue());
            }
            String javaType = type.get(JAVA_TYPE).textValue();
            Optional<Schema> first = components.getSchemas().values().stream().filter(schema -> schema.getExtensions() != null && javaType.equals(schema.getExtensions().get("x-java-type"))).findFirst();
            if (first.isPresent()) {
                log.debug("Found Schema: {} for javaType: {} ", (Object)first.get().getName(), (Object)javaType);
                return first.get();
            }
        }
        return null;
    }

    static Optional<String> getSchemaNameFromJavaClass(JsonNode type) {
        if (type.hasNonNull(JAVA_TYPE)) {
            String javaType;
            if (log.isDebugEnabled()) {
                log.debug("javaType: {}", (Object)type.get(JAVA_TYPE).textValue());
            }
            if (!(javaType = type.get(JAVA_TYPE).textValue()).startsWith("java.")) {
                return Optional.of(StringUtils.substringAfterLast((String)javaType, (String)"."));
            }
        }
        return Optional.empty();
    }

    static String getSchemaNameFromReference(URL absoluteReference, String parentSchemaName, BiMap<String, String> referenceNames) {
        return Utils.getSchemaNameFromReference(absoluteReference.toString(), parentSchemaName, referenceNames);
    }

    static String getSchemaNameFromReference(String reference, String parentSchemaName, BiMap<String, String> referenceNames) {
        String name;
        String proposedName = Utils.getProposedSchemaName(reference);
        String existingName = (String)referenceNames.get((Object)reference);
        String existingRef = (String)referenceNames.inverse().get((Object)proposedName);
        if (existingName == null && existingRef == null) {
            try {
                referenceNames.put((Object)reference, (Object)proposedName);
            }
            catch (IllegalArgumentException ex) {
                log.error("thingy already exists");
            }
            name = proposedName;
        } else if (existingName != null && existingRef != null && existingName.equals(proposedName) && existingRef.equals(reference)) {
            name = proposedName;
        } else if (Utils.isUrl(reference)) {
            URL parent = Utils.getAbsoluteReferenceParent(reference);
            String parentReference = StringUtils.stripEnd((String)parent.toString(), (String)"/");
            String parentName = Utils.getProposedSchemaName(parentReference);
            String newName = parentName + proposedName;
            log.warn("Schema Name already exists for: {} Using: {}", (Object)proposedName, (Object)newName);
            proposedName = newName;
            referenceNames.put((Object)reference, (Object)proposedName);
            name = proposedName;
        } else {
            String newName = proposedName + "Duplicate";
            log.warn("Schema Name already exists for{} Using: {}", (Object)proposedName, (Object)newName);
            referenceNames.put((Object)reference, (Object)newName);
            name = newName;
        }
        return name;
    }

    protected static String getProposedSchemaName(String absoluteReference) {
        String proposedName = absoluteReference;
        if (proposedName.contains("/")) {
            proposedName = StringUtils.substringAfterLast((String)proposedName, (String)"/");
        }
        proposedName = StringUtils.substringBeforeLast((String)proposedName, (String)".");
        return Utils.normalizeSchemaName(proposedName);
    }

    public static String normalizeSchemaName(String name) {
        name = name.contains("-") ? CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name) : CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, name);
        name = name.replaceAll("[^A-Za-z0-9]", "");
        name = org.apache.commons.lang3.StringUtils.deleteWhitespace((String)name);
        return name;
    }

    public static String normalizeDisplayName(String name) {
        name = name.replaceAll("[^A-Za-z0-9]", "");
        return name;
    }

    protected static Set<String> getPlaceholders(String url) {
        Matcher m = Pattern.compile("\\{(.*?)\\}").matcher(url);
        LinkedHashSet<String> placeholders = new LinkedHashSet<String>();
        while (m.find()) {
            String match = m.group(0);
            placeholders.add(match.substring(1, match.length() - 1));
        }
        return placeholders;
    }

    protected static boolean isUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void cleanUp(Schema schema, boolean removeJavaExtensions) {
        if (schema == null) {
            return;
        }
        if (schema.getExtensions() != null) {
            schema.getExtensions().remove("x-raml-type");
            schema.getExtensions().remove("x-raml-base");
            schema.getExtensions().remove("x-raml-parent");
            schema.getExtensions().remove("x-raml-extends");
            if (removeJavaExtensions) {
                schema.getExtensions().remove("x-java-type");
                schema.getExtensions().remove("x-java-enum-names");
            }
        }
        if (schema.getProperties() != null) {
            schema.getProperties().forEach((s, prop) -> Utils.cleanUp((Schema)prop, removeJavaExtensions));
        }
        if (schema instanceof ArraySchema) {
            Utils.cleanUp(((ArraySchema)schema).getItems(), removeJavaExtensions);
        }
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            if (composedSchema.getAllOf() != null) {
                composedSchema.getAllOf().forEach(schema1 -> Utils.cleanUp(schema1, removeJavaExtensions));
            }
            if (composedSchema.getAnyOf() != null) {
                composedSchema.getAnyOf().forEach(schema1 -> Utils.cleanUp(schema1, removeJavaExtensions));
            }
            if (composedSchema.getOneOf() != null) {
                composedSchema.getOneOf().forEach(schema1 -> Utils.cleanUp(schema1, removeJavaExtensions));
            }
        }
    }

    public static ObjectMapper createObjectMapper() {
        YAMLFactory yamlFactory = new YAMLFactory();
        yamlFactory.enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature());
        return new ObjectMapper((JsonFactory)yamlFactory);
    }

    public static String[] selectInputs(Path inputPath, String glob) throws IOException {
        PathMatcher matcher = inputPath.getFileSystem().getPathMatcher("glob:" + glob);
        try (Stream<Path> paths = Files.list(inputPath);){
            String[] stringArray = (String[])paths.map(inputPath::relativize).filter(matcher::matches).map(Path::toString).toArray(String[]::new);
            return stringArray;
        }
    }
}

