/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.loader;

import com.backbase.oss.boat.loader.OpenAPILoaderException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPILoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenAPILoader.class);

    private OpenAPILoader() {
        throw new AssertionError((Object)"Private constructor");
    }

    public static OpenAPI parse(String openApi) throws OpenAPILoaderException {
        OpenAPIV3Parser openAPIParser = new OpenAPIV3Parser();
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setFlattenComposedSchemas(true);
        parseOptions.setResolveCombinators(true);
        SwaggerParseResult swaggerParseResult = null;
        try {
            swaggerParseResult = openAPIParser.readContents(openApi);
        }
        catch (Exception e) {
            throw new OpenAPILoaderException("Cannot parse openAPI", e);
        }
        if (swaggerParseResult.getOpenAPI() == null) {
            throw new OpenAPILoaderException("Cannot parse OpenAPI", swaggerParseResult.getMessages());
        }
        return swaggerParseResult.getOpenAPI();
    }

    public static OpenAPI load(String url) throws OpenAPILoaderException {
        return OpenAPILoader.load(url, false, false);
    }

    public static OpenAPI load(File file) throws OpenAPILoaderException {
        return OpenAPILoader.load(file, false, false);
    }

    public static OpenAPI load(File file, boolean resolveFully) throws OpenAPILoaderException {
        return OpenAPILoader.load(file, resolveFully, false);
    }

    public static OpenAPI load(File file, boolean resolveFully, boolean flatten) throws OpenAPILoaderException {
        if (!file.exists()) {
            throw new OpenAPILoaderException("Could not load open api from file :" + file.getAbsolutePath() + ". File does not exist!");
        }
        return OpenAPILoader.load(file.toURI().toString(), resolveFully, flatten);
    }

    public static OpenAPI load(String url, boolean resolveFully, boolean flatten) throws OpenAPILoaderException {
        log.debug("Reading OpenAPI from: {} resolveFully: {}", (Object)url, (Object)resolveFully);
        OpenAPIV3Parser openAPIParser = new OpenAPIV3Parser();
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setFlatten(flatten);
        parseOptions.setResolve(resolveFully);
        parseOptions.setResolveFully(resolveFully);
        parseOptions.setFlattenComposedSchemas(true);
        parseOptions.setResolveCombinators(true);
        SwaggerParseResult swaggerParseResult = openAPIParser.readLocation(url, null, parseOptions);
        if (swaggerParseResult.getOpenAPI() == null) {
            log.error("Could not load OpenAPI from : {} \n{}", (Object)url, (Object)String.join((CharSequence)"\t\n", swaggerParseResult.getMessages()));
            throw new OpenAPILoaderException("Could not load open api from :" + url, swaggerParseResult.getMessages());
        }
        return swaggerParseResult.getOpenAPI();
    }
}

