/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.loader;

import com.backbase.oss.boat.loader.RamlLoaderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlResourceLoader
implements ResourceLoaderExtended {
    private final Logger log = LoggerFactory.getLogger(RamlResourceLoader.class);
    private final ResourceLoader fallBackResourceLoader = new DefaultResourceLoader();
    private final File baseDir;
    private final File root;

    public RamlResourceLoader(File baseDir, File root) {
        this.root = root;
        this.baseDir = baseDir;
    }

    @Nullable
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        this.log.debug("Fetching resource: {}", (Object)resourceName);
        File file = new File(resourceName);
        if (!file.isAbsolute() && !(file = new File(this.root, resourceName)).exists()) {
            file = new File(this.baseDir, resourceName);
        }
        if (!file.exists()) {
            this.log.debug("File {} does not seem to exist, falling back to default resource loader.", (Object)file.getAbsolutePath());
            if (this.fallBackResourceLoader instanceof ResourceLoaderExtended && callback != null) {
                return ((ResourceLoaderExtended)this.fallBackResourceLoader).fetchResource(resourceName, callback);
            }
            return this.fallBackResourceLoader.fetchResource(resourceName);
        }
        if (file.isDirectory()) {
            throw new RamlLoaderException("Cannot read " + file + " (Is a directory)");
        }
        try {
            this.log.debug("Returning {}", (Object)file.getAbsolutePath());
            if (callback != null) {
                callback.onResourceFound(file.toURI());
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RamlLoaderException("File not found: " + file, e);
        }
    }

    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    public URI getUriCallBackParam() {
        return this.fallBackResourceLoader instanceof ResourceLoaderExtended ? ((ResourceLoaderExtended)this.fallBackResourceLoader).getUriCallBackParam() : null;
    }
}

