/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.transformers.Transformer;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decomposer
implements Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Decomposer.class);

    @Override
    public OpenAPI transform(OpenAPI openAPI, Map<String, Object> options) {
        List<Schema> composedSchemas = openAPI.getComponents().getSchemas().values().stream().filter(schema -> schema instanceof ComposedSchema).collect(Collectors.toList());
        composedSchemas.forEach(composedSchema -> this.mergeComposedSchema(openAPI, (Schema)composedSchema));
        for (Schema composedSchema2 : composedSchemas) {
            ((ComposedSchema)composedSchema2).setAllOf(null);
        }
        return openAPI;
    }

    private void mergeComposedSchema(OpenAPI openAPI, Schema composedSchema) {
        ((ComposedSchema)composedSchema).getAllOf().stream().map(schemaReference -> {
            String key = StringUtils.substringAfterLast((String)schemaReference.get$ref(), (String)"/");
            Schema schema = (Schema)openAPI.getComponents().getSchemas().get(key);
            if (schema == null) {
                log.info("huh??");
            }
            return schema;
        }).forEach(schema -> {
            log.debug("Merging properties from referenced Schema: {}", (Object)schema.getName());
            if (schema instanceof ComposedSchema) {
                this.mergeComposedSchema(openAPI, (Schema)schema);
            }
            this.mergeSchemas(composedSchema, (Schema)schema);
        });
    }

    private void mergeSchemas(Schema composedSchema, Schema schema) {
        if (composedSchema.getProperties() == null) {
            composedSchema.setProperties(new LinkedHashMap());
        }
        if (composedSchema.getRequired() == null && schema.getRequired() != null) {
            composedSchema.required(new ArrayList());
        }
        if (schema.getRequired() != null) {
            List<Object> required = new ArrayList(composedSchema.getRequired());
            required.addAll(schema.getRequired());
            required = required.stream().distinct().collect(Collectors.toList());
            composedSchema.required(required);
        }
        composedSchema.getProperties().putAll(schema.getProperties());
    }
}

