/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.transformers.Transformer;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import lombok.NonNull;

public class VendorExtensionFilter
implements Transformer {
    @Override
    @NonNull
    public OpenAPI transform(@NonNull OpenAPI openAPI, @NonNull Map<String, Object> options) {
        if (openAPI == null) {
            throw new NullPointerException("openAPI is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return Optional.ofNullable(options.get("remove")).map(remove -> this.transform(openAPI, (Collection)remove)).orElse(openAPI);
    }

    private OpenAPI transform(OpenAPI source, Collection<String> remove) {
        ObjectMapper mapper = Yaml.mapper();
        JsonNode tree = mapper.valueToTree((Object)source);
        if (tree instanceof ContainerNode) {
            this.removeExtensions((ContainerNode)tree, remove);
        }
        return (OpenAPI)mapper.treeToValue((TreeNode)tree, OpenAPI.class);
    }

    private void removeExtensions(ContainerNode node, Collection<String> remove) {
        if (node.isObject()) {
            ((ObjectNode)node).remove(remove);
        }
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.elements(), 16), false).filter(ContainerNode.class::isInstance).map(ContainerNode.class::cast).forEach(child -> this.removeExtensions((ContainerNode)child, remove));
    }
}

