/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers.bundler;

import com.backbase.oss.boat.transformers.TransformerException;
import com.backbase.oss.boat.transformers.bundler.ExamplesProcessor;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.models.RefFormat;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoatCache
extends ResolverCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BoatCache.class);
    private final ExamplesProcessor examplesProcessor;

    public BoatCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, ExamplesProcessor examplesProcessor) {
        super(openApi, auths, parentFileLocation);
        this.examplesProcessor = examplesProcessor;
    }

    public <T> T loadRef(String ref, RefFormat refFormat, Class<T> expectedType) {
        log.debug("loadRef {}, {}, {}", new Object[]{ref, refFormat, expectedType});
        Object result = null;
        try {
            result = super.loadRef(ref, refFormat, expectedType);
        }
        catch (Exception e) {
            log.debug("Reference: {} is something else than json or yaml", (Object)ref);
            throw new TransformerException("Reference: " + ref + " cannot be loaded", e);
        }
        if (result instanceof ApiResponse) {
            ApiResponse response = (ApiResponse)result;
            String relativePath = null;
            if (refFormat == RefFormat.RELATIVE) {
                relativePath = Paths.get(ref.substring(0, ref.indexOf("#")), new String[0]).getParent().toString();
            }
            this.examplesProcessor.processContent(response.getContent(), relativePath);
        }
        return (T)result;
    }
}

