/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers.bundler;

import com.backbase.oss.boat.transformers.TransformerException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.examples.Example;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExampleHolder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExampleHolder.class);
    private static final String FIXING_INVALID_EXAMPLE_WARNING = "%1$s is an invalid example. \nYou've got:\n%1$s:\n  value:\n    $ref: %2$s\nOnly the whole example can be a reference object:\n%1$s:\n  $ref: %2$s";
    private static final String REF_KEY = "$ref";
    public static final String VALUE = "value";
    private final String name;
    private T example;
    private String content;

    private ExampleHolder(String name, T example) {
        this.name = name;
        this.example = example;
    }

    public T example() {
        return this.example;
    }

    public void setExample(T example) {
        this.example = example;
    }

    abstract String getRef();

    abstract void replaceRef(String var1);

    public static ExampleHolder<Example> of(String name, Example example, boolean isComponentExample) {
        return new ExampleExampleHolder(name, example, isComponentExample);
    }

    public static ExampleHolder of(String name, Object o) {
        if (o instanceof ObjectNode) {
            return new ObjectNodeExampleHolder(name, (ObjectNode)o);
        }
        if (o instanceof Map) {
            return new MapExampleHolder(name, (Map)o);
        }
        if (o instanceof Example) {
            boolean isComponentSection = ((Example)o).get$ref() != null && ((Example)o).get$ref().startsWith("#/components");
            try {
                String s = Json.mapper().writeValueAsString(o);
                return new ObjectNodeExampleHolder(name, (ObjectNode)Json.mapper().readTree(s));
            }
            catch (JsonProcessingException e) {
                return new ExampleExampleHolder(name, (Example)o, isComponentSection);
            }
        }
        if (o instanceof ArrayNode) {
            return new ArrayNodeExampleHolder(name, (ArrayNode)o);
        }
        throw new TransformerException("Unknown type backing example " + o.getClass().getName());
    }

    public String toString() {
        return "ExampleHolder{name='" + this.name + '\'' + ", ref=" + this.getRef() + '}';
    }

    public String getExampleName() {
        return this.name != null ? this.name : StringUtils.replaceEach((String)this.getRef(), (String[])new String[]{"./", "examples/", ".json", ".", "/"}, (String[])new String[]{"", "", "", "", "-"});
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    private static class MapExampleHolder
    extends ExampleHolder<Map> {
        private MapExampleHolder(String name, Map map) {
            super(name, map);
        }

        @Override
        String getRef() {
            return (String)((Map)this.example()).get(ExampleHolder.REF_KEY);
        }

        @Override
        void replaceRef(String ref) {
            ((Map)this.example()).put(ExampleHolder.REF_KEY, ref);
        }
    }

    public static class ArrayNodeExampleHolder
    extends ExampleHolder<ArrayNode> {
        private ArrayNodeExampleHolder(String name, ArrayNode arrayNode) {
            super(name, arrayNode);
        }

        @Override
        String getRef() {
            return null;
        }

        @Override
        void replaceRef(String ref) {
        }
    }

    public static class ObjectNodeExampleHolder
    extends ExampleHolder<ObjectNode> {
        private ObjectNodeExampleHolder(String name, ObjectNode objectNode) {
            super(name, objectNode);
            if (objectNode.get(ExampleHolder.REF_KEY) == null && objectNode.get(ExampleHolder.VALUE) != null && objectNode.get(ExampleHolder.VALUE).get(ExampleHolder.REF_KEY) != null) {
                String ref = objectNode.get(ExampleHolder.VALUE).get(ExampleHolder.REF_KEY).asText();
                log.warn(String.format(ExampleHolder.FIXING_INVALID_EXAMPLE_WARNING, "?", ref));
                objectNode.set(ExampleHolder.REF_KEY, objectNode.get(ExampleHolder.VALUE).get(ExampleHolder.REF_KEY));
                objectNode.remove(ExampleHolder.VALUE);
            }
        }

        @Override
        String getRef() {
            JsonNode jsonNode = ((ObjectNode)this.example()).get(ExampleHolder.REF_KEY);
            if (jsonNode != null) {
                return jsonNode.asText();
            }
            return null;
        }

        @Override
        void replaceRef(String ref) {
            ((ObjectNode)this.example()).put(ExampleHolder.REF_KEY, ref);
        }
    }

    private static class ExampleExampleHolder
    extends ExampleHolder<Example> {
        private final boolean componentExample;

        private ExampleExampleHolder(String name, Example example, boolean componentExample) {
            super(name, example);
            this.componentExample = componentExample;
            if (example.get$ref() == null && example.getValue() instanceof ObjectNode && ((ObjectNode)example.getValue()).get(ExampleHolder.REF_KEY) != null) {
                String ref = ((ObjectNode)example.getValue()).get(ExampleHolder.REF_KEY).asText();
                log.warn(String.format(ExampleHolder.FIXING_INVALID_EXAMPLE_WARNING, name, ref));
                example.set$ref(ref);
                example.setValue(null);
            }
        }

        @Override
        String getRef() {
            return ((Example)this.example()).get$ref();
        }

        @Override
        void replaceRef(String ref) {
            if (this.componentExample) {
                ((Example)this.example()).set$ref(null);
            } else {
                ((Example)this.example()).set$ref(ref);
            }
        }
    }
}

