/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers.bundler;

import com.backbase.oss.boat.transformers.TransformerException;
import com.backbase.oss.boat.transformers.bundler.ExampleHolder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.util.RefUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamplesProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExamplesProcessor.class);
    public static final String COMPONENTS_EXAMPLES = "#/components/examples/";
    ObjectMapper yamlObjectMapper = new ObjectMapper((JsonFactory)YAMLFactory.builder().build());
    ObjectMapper jsonObjectMapper = new ObjectMapper();
    private final OpenAPI openAPI;
    private final URI rootUri;
    private final Map<String, ExampleHolder> cache = new LinkedHashMap<String, ExampleHolder>();

    public ExamplesProcessor(OpenAPI openAPI, String inputUri) {
        this.openAPI = openAPI;
        try {
            this.rootUri = URI.create(inputUri).resolve(".");
        }
        catch (RuntimeException e) {
            log.error("Unable to create URI from \"{}\"", (Object)inputUri);
            throw e;
        }
    }

    public void processExamples(OpenAPI openAPI) {
        log.debug("Processing examples in Components");
        this.getComponentExamplesFromOpenAPI().entrySet().stream().map(e -> ExampleHolder.of((String)e.getKey(), (Example)e.getValue(), true)).forEach(this::fixInlineExamples);
        openAPI.getPaths().forEach((path, pathItem) -> {
            log.debug("Processing examples in Path: {}", path);
            pathItem.readOperationsMap().forEach((httpMethod, operation) -> {
                log.debug("Processing examples in Operation: {}", httpMethod);
                if (operation.getRequestBody() != null) {
                    operation.getRequestBody().getContent().forEach((contentType, mediaType) -> {
                        log.debug("Processing Request Body examples for Content Type: {}", contentType);
                        this.processMediaType((MediaType)mediaType, null, false);
                    });
                }
                operation.getResponses().forEach((responseCode, apiResponse) -> {
                    log.debug("Processing Response Body Examples for Response Code: {}", responseCode);
                    if (apiResponse.getContent() != null) {
                        apiResponse.getContent().forEach((contentType, mediaType) -> {
                            log.debug("Processing Response Body Examples for Content Type: {}", contentType);
                            this.processMediaType((MediaType)mediaType, null, false);
                        });
                    }
                });
            });
        });
    }

    public void processContent(Content content, String relativePath) {
        content.forEach((s, mediaType) -> {
            log.debug("Processing Consent for: {} with relative path: {}", s, (Object)relativePath);
            this.processMediaType((MediaType)mediaType, relativePath, true);
        });
    }

    public void processMediaType(MediaType mediaType, String relativePath, boolean derefenceExamples) {
        if (mediaType.getExamples() != null) {
            mediaType.getExamples().forEach((key, example) -> {
                log.debug("Processing Example: {} with value: {} and ref: {} ", new Object[]{key, example.getValue(), example.get$ref()});
                ExampleHolder exampleHolder = ExampleHolder.of(key, example);
                this.fixInlineExamples(exampleHolder, relativePath, derefenceExamples);
                if (exampleHolder.getRef() != null) {
                    example.set$ref(exampleHolder.getRef());
                    example.setValue(null);
                } else {
                    example.setValue(exampleHolder.example());
                }
                log.debug("Finished Processing Example: {} with value: {}", key, (Object)exampleHolder);
            });
        }
        if (mediaType.getExample() != null) {
            log.debug("Processing Example: {} ", mediaType.getExample());
            ExampleHolder exampleHolder = ExampleHolder.of(null, mediaType.getExample());
            this.fixInlineExamples(exampleHolder, relativePath, false);
            log.debug("Finished Processing Example: {}", (Object)exampleHolder);
        }
    }

    private void putComponentExample(String key, Example example) {
        this.getComponentExamplesFromOpenAPI().put(key, example);
    }

    private Map<String, Example> getComponentExamplesFromOpenAPI() {
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if (this.openAPI.getComponents().getExamples() == null) {
            this.openAPI.getComponents().setExamples(new LinkedHashMap());
        }
        return this.openAPI.getComponents().getExamples();
    }

    private void fixInlineExamples(ExampleHolder exampleHolder) {
        this.fixInlineExamples(exampleHolder, null, false);
    }

    private void fixInlineExamples(ExampleHolder exampleHolder, String relativePath, boolean derefenceExamples) {
        Optional<Object> fragment;
        log.debug("fixInlineExamples: '{}', relative resolvedUri '{}'", (Object)exampleHolder, (Object)relativePath);
        if (exampleHolder.getRef() == null) {
            log.debug("not fixing (ref not found): {}", (Object)exampleHolder);
            return;
        }
        String refPath = exampleHolder.getRef();
        if (RefUtils.computeRefFormat((String)refPath) != RefFormat.RELATIVE) {
            log.debug("not fixing (not relative ref): '{}'", (Object)exampleHolder);
            return;
        }
        if (refPath.startsWith(COMPONENTS_EXAMPLES)) {
            log.debug("Ref resolvedUri already points to examples. Leave it as it is");
            return;
        }
        if (refPath.contains("#") && !refPath.startsWith("#/components/examples")) {
            fragment = Optional.of(StringUtils.substringAfter((String)refPath, (String)"#"));
            refPath = StringUtils.strip((String)StringUtils.substringBefore((String)refPath, (String)"#"), (String)"./");
        } else {
            fragment = Optional.empty();
        }
        URI resolvedUri = this.resolveUri(relativePath, refPath);
        try {
            String content = this.readContent(Paths.get(resolvedUri));
            if (fragment.isPresent()) {
                String exampleName = StringUtils.substringAfterLast((String)((String)fragment.get()), (String)"/");
                JsonNode jsonNode = this.yamlObjectMapper.readTree(content);
                JsonPointer jsonPointer = JsonPointer.compile((String)((String)fragment.get()));
                JsonNode exampleNode = jsonNode.at(jsonPointer);
                this.processInLineExample(exampleHolder, relativePath, exampleNode, exampleName);
            } else {
                exampleHolder.setContent(content);
                this.dereferenceExample(exampleHolder);
            }
            if (derefenceExamples) {
                this.dereferenceExample(exampleHolder);
            }
        }
        catch (IOException e) {
            throw new TransformerException("Unable to fix inline examples", e);
        }
    }

    private void processInLineExample(ExampleHolder exampleHolder, String relativePath, JsonNode exampleNode, String exampleName) throws IOException {
        if (exampleNode.has("$ref")) {
            String refPath = exampleNode.get("$ref").asText();
            exampleHolder.replaceRef(refPath);
            URI resolvedUri = this.resolveUri(relativePath, refPath);
            this.resolveUri(relativePath, refPath);
            String content = this.readContent(Paths.get(resolvedUri));
            exampleHolder.setContent(content);
            if (exampleName != null) {
                exampleHolder.replaceRef(COMPONENTS_EXAMPLES + exampleName);
            }
            if (this.getComponentExamplesFromOpenAPI().containsKey(exampleName)) {
                log.debug("Updating example: {} in components/examples", (Object)exampleName);
            } else {
                log.debug("Adding Example: {} to components/examples", (Object)exampleName);
                this.putComponentExample(exampleName, new Example().value(this.convertExampleContent(exampleHolder, refPath)));
            }
        } else {
            exampleHolder.setContent(this.jsonObjectMapper.writeValueAsString((Object)exampleNode));
        }
    }

    private String readContent(Path path) throws IOException {
        String content = StringUtils.strip((String)StringUtils.replaceEach((String)new String(Files.readAllBytes(path)), (String[])new String[]{"\t"}, (String[])new String[]{"  "}));
        return content;
    }

    private URI resolveUri(String relativePath, String refPath) {
        URI resolvedUri = relativePath == null ? this.rootUri.resolve(StringUtils.strip((String)refPath, (String)"./")) : this.rootUri.resolve(this.checkTrailingSlash(relativePath.replace("\\", "/"))).resolve(refPath.replace("\\", "/"));
        return resolvedUri;
    }

    private void dereferenceExample(ExampleHolder exampleHolder) {
        String rootName = exampleHolder.getExampleName();
        int count = 0;
        while (this.existsButNotMatching(this.cache.get(this.makeCountedName(rootName, count)), exampleHolder)) {
            ++count;
        }
        String exampleName = this.makeCountedName(rootName, count);
        Object content = this.convertExampleContent(exampleHolder, exampleHolder.getRef());
        this.cache.put(exampleName, exampleHolder);
        exampleHolder.replaceRef(COMPONENTS_EXAMPLES + exampleName);
        this.putComponentExample(exampleName, new Example().value(content).summary(exampleName));
    }

    private Object convertExampleContent(ExampleHolder exampleHolder, String refPath) {
        try {
            if (exampleHolder.getRef().endsWith("json") || refPath.endsWith("json")) {
                return Json.mapper().readValue(exampleHolder.getContent(), Object.class);
            }
            return exampleHolder.getContent();
        }
        catch (JsonProcessingException | RuntimeException e) {
            throw new TransformerException("Failed to process example content for " + exampleHolder, e);
        }
    }

    private boolean existsButNotMatching(ExampleHolder cached, ExampleHolder exampleHolder) {
        return cached != null && !Objects.equals(cached.getContent(), exampleHolder.getContent());
    }

    private String makeCountedName(String s, int count) {
        return count == 0 ? s : s + "-" + count;
    }

    private String checkTrailingSlash(String uri) {
        return uri.endsWith("/") ? uri : uri + "/";
    }
}

