/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ResourcePathUtils {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{([^}]+)\\}");

    public static String toAbsoluteLocation(String basePathParam, String relativePathParam) {
        int lastSlash;
        String relativePath;
        String basePath = basePathParam.replace("\\", "/");
        String result = relativePath = relativePathParam.replace("\\", "/");
        if (!ResourcePathUtils.isAbsolute(relativePath) && (lastSlash = basePath.lastIndexOf(47)) != -1) {
            result = basePath.substring(0, lastSlash + 1) + relativePath;
        }
        if (result.contains("#")) {
            return result.split("#")[0];
        }
        return result;
    }

    public static boolean isAbsolute(String includePath) {
        return includePath.startsWith("http:") || includePath.startsWith("https:") || includePath.startsWith("file:") || includePath.startsWith("/") || new File(includePath).isAbsolute();
    }

    public static List<String> getUriTemplates(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            Matcher m = TEMPLATE_PATTERN.matcher(value);
            while (m.find()) {
                result.add(m.group(1));
            }
        }
        return result;
    }

    @Generated
    private ResourcePathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

