/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.example.NamedExample;
import com.backbase.oss.boat.transformers.OpenAPIExtractor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryExploder {
    private static final Logger log = LoggerFactory.getLogger(DirectoryExploder.class);
    private static final String EXAMPLES_DIR = "examples";
    @NotNull
    private final OpenAPIExtractor openAPIExtractor;
    @NotNull
    private final ObjectWriter writer;

    public DirectoryExploder(@NotNull OpenAPIExtractor openAPIExtractor, @NotNull ObjectWriter writer) {
        this.openAPIExtractor = openAPIExtractor;
        this.writer = writer;
    }

    public void serializeIntoDirectory(@NotNull Path outputPath) throws IOException {
        List<NamedExample> examples = this.openAPIExtractor.extractInlineExamples();
        if (Files.exists(outputPath, new LinkOption[0])) {
            FileUtils.cleanDirectory((File)outputPath.toFile());
        }
        Path examplesPath = outputPath.resolve(EXAMPLES_DIR);
        Files.createDirectories(examplesPath, new FileAttribute[0]);
        examples.forEach(namedExample -> {
            String title = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, namedExample.getName());
            String serializedValue = "";
            try {
                serializedValue = this.writer.writeValueAsString(namedExample.getExample().getValue());
                String filename = title + ".json";
                Path exampleFile = examplesPath.resolve(filename);
                if (Files.notExists(exampleFile, new LinkOption[0])) {
                    Files.createFile(exampleFile, new FileAttribute[0]);
                }
                Files.write(exampleFile, serializedValue.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                namedExample.getExample().setValue(null);
                String ref = EXAMPLES_DIR + File.separator + filename;
                namedExample.getExample().set$ref(ref);
            }
            catch (JsonProcessingException e) {
                log.error("Could not serialize to JSON", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Could not write to file: {}.\nError: {}.\nSerialized value: {}", new Object[]{title, e, serializedValue});
            }
        });
    }
}

