/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers.bundler;

import com.backbase.oss.boat.transformers.bundler.BoatCache;
import com.backbase.oss.boat.transformers.bundler.ExamplesProcessor;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.processors.ComponentsProcessor;
import io.swagger.v3.parser.processors.OperationProcessor;
import io.swagger.v3.parser.processors.PathsProcessor;
import java.util.List;

public class BoatOpenAPIResolver {
    private final OpenAPI openApi;
    private final ComponentsProcessor componentsProcessor;
    private final PathsProcessor pathProcessor;
    private final OperationProcessor operationsProcessor;
    private final ExamplesProcessor examplesProcessor;

    public BoatOpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this(openApi, auths, parentFileLocation, null);
    }

    public BoatOpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, OpenAPIResolver.Settings settings) {
        this.openApi = openApi;
        OpenAPIResolver.Settings openApiResolverSettings = settings != null ? settings : new OpenAPIResolver.Settings();
        this.examplesProcessor = new ExamplesProcessor(openApi, parentFileLocation);
        BoatCache cache = new BoatCache(openApi, auths, parentFileLocation, this.examplesProcessor);
        this.componentsProcessor = new ComponentsProcessor(openApi, (ResolverCache)cache);
        this.pathProcessor = new PathsProcessor((ResolverCache)cache, openApi, openApiResolverSettings);
        this.operationsProcessor = new OperationProcessor((ResolverCache)cache, openApi);
    }

    public OpenAPI resolve() {
        if (this.openApi == null) {
            return null;
        }
        this.examplesProcessor.processExamples(this.openApi);
        this.processOpenAPI();
        return this.openApi;
    }

    /*
     * Unable to fully structure code
     */
    private void processOpenAPI() {
        this.pathProcessor.processPaths();
        this.componentsProcessor.processComponents();
        if (this.openApi.getPaths() == null) {
            return;
        }
        var1 = this.openApi.getPaths().keySet().iterator();
        block0: while (true) {
            if (!var1.hasNext()) {
                return;
            }
            pathname = (String)var1.next();
            pathItem = (PathItem)this.openApi.getPaths().get((Object)pathname);
            if (pathItem.readOperations() == null) continue;
            var3_3 = pathItem.readOperations().iterator();
            while (true) {
                if (var3_3.hasNext()) ** break;
                continue block0;
                operation = (Operation)var3_3.next();
                this.operationsProcessor.processOperation(operation);
            }
            break;
        }
    }
}

