/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.XML;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlSchemaToOpenApi {
    @Generated
    private static final Logger log = Logger.getLogger(XmlSchemaToOpenApi.class.getName());
    public static final String NAME = "name";
    public static final String TYPE = "type";
    private static final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    private XmlSchemaToOpenApi() {
        throw new AssertionError((Object)"Private constructor");
    }

    public static Schema convert(String name, String schemaContent, Components components) {
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(IOUtils.toInputStream((String)schemaContent, (Charset)StandardCharsets.UTF_8));
        XML xml = new XML();
        xml.addExtension("x-bb-schema-content", (Object)schemaContent);
        Schema root = new Schema();
        root.name(name);
        XmlSchemaToOpenApi.map(doc.getDocumentElement(), root, components);
        components.addSchemas(name, root);
        return root;
    }

    private static void map(Element node, Schema schema, Components components) {
        String name;
        Element element;
        int i;
        NodeList complexTypes = node.getElementsByTagName("xs:complexType");
        for (int i2 = 0; i2 < complexTypes.getLength(); ++i2) {
            Element complexType = (Element)complexTypes.item(i2);
            String name2 = complexType.getAttribute(NAME);
            Schema complexTypeSchema = (Schema)components.getSchemas().getOrDefault(name2, new ObjectSchema());
            XmlSchemaToOpenApi.map(complexType, complexTypeSchema, components);
            components.addSchemas(name2, complexTypeSchema);
        }
        NodeList elements = node.getElementsByTagName("xs:element");
        for (i = 0; i < elements.getLength(); ++i) {
            element = (Element)elements.item(i);
            name = element.getAttribute(NAME);
            String type = element.getAttribute(TYPE);
            if (StringUtils.isEmpty((CharSequence)type)) {
                type = "string";
            }
            Schema propertySchema = XmlSchemaToOpenApi.createSchemaFor(type, components);
            propertySchema.setName(name);
            schema.addProperties(name, propertySchema);
        }
        for (i = 0; i < elements.getLength(); ++i) {
            element = (Element)elements.item(i);
            name = node.getAttribute(NAME);
            ArraySchema arraySchema = new ArraySchema();
            arraySchema.setName(name);
            Schema itemSchema = new Schema();
            XmlSchemaToOpenApi.map(element, itemSchema, components);
            arraySchema.setItems(itemSchema);
            schema.$ref(name);
        }
    }

    private static Schema createSchemaFor(String type, Components components) {
        switch (type) {
            case "xs:string": {
                return new StringSchema();
            }
            case "xs:boolean": {
                return new BooleanSchema();
            }
            case "xs:int": {
                return new IntegerSchema();
            }
        }
        Schema complexType = (Schema)components.getSchemas().get(type);
        if (complexType == null) {
            complexType = new ObjectSchema();
            components.addSchemas(type, complexType);
        }
        return complexType;
    }
}

