/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.example.NamedExample;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public final class ExampleExtractors {
    @NotNull
    static List<NamedExample> headerExamples(@NotNull Header header) {
        String prefix = ExampleExtractors.prefixFromSchema(header.getSchema());
        List<NamedExample> allExamples = Optional.ofNullable(header.getExamples()).orElse(Collections.emptyMap()).entrySet().stream().map(entry -> new NamedExample(ExampleExtractors.exampleName(prefix, (String)entry.getKey()), (Example)entry.getValue())).collect(Collectors.toList());
        if (header.getContent() != null) {
            allExamples.addAll(ExampleExtractors.contentExamples(header.getContent()));
        }
        return allExamples;
    }

    @NotNull
    static List<NamedExample> parameterExamples(@NotNull Parameter parameter) {
        List<NamedExample> allExamples = Optional.ofNullable(parameter.getExamples()).orElse(Collections.emptyMap()).entrySet().stream().map(entry -> new NamedExample(ExampleExtractors.exampleName(parameter.getName(), (String)entry.getKey()), (Example)entry.getValue())).collect(Collectors.toList());
        if (parameter.getContent() != null) {
            allExamples.addAll(ExampleExtractors.contentExamples(parameter.getContent()));
        }
        return allExamples;
    }

    @NotNull
    static List<NamedExample> contentExamples(@NotNull Content content) {
        return content.values().stream().flatMap(mediaType -> ExampleExtractors.mediaTypeExamples(mediaType).stream()).collect(Collectors.toList());
    }

    @NotNull
    static List<NamedExample> mediaTypeExamples(@NotNull MediaType mediaType) {
        String prefix = ExampleExtractors.prefixFromSchema(mediaType.getSchema());
        Collection examples = Optional.ofNullable(mediaType.getExamples()).orElse(Collections.emptyMap()).entrySet().stream().map(entry -> new NamedExample(ExampleExtractors.exampleName(prefix, (String)entry.getKey()), (Example)entry.getValue())).collect(Collectors.toList());
        Collection encodingHeadersExamples = Optional.ofNullable(mediaType.getEncoding()).orElse(Collections.emptyMap()).values().stream().filter(encoding -> encoding.getHeaders() != null).flatMap(encoding -> encoding.getHeaders().entrySet().stream()).flatMap(headerEntry -> ExampleExtractors.headerExamples((Header)headerEntry.getValue()).stream()).collect(Collectors.toList());
        ArrayList<NamedExample> allExamples = new ArrayList<NamedExample>();
        allExamples.addAll(examples);
        allExamples.addAll(encodingHeadersExamples);
        return allExamples;
    }

    @NotNull
    private static String prefixFromSchema(@Nullable Schema<?> optSchema) {
        return Optional.ofNullable(optSchema).map(schema -> Optional.ofNullable(schema.getName()).orElse(Optional.ofNullable(schema.get$ref()).map(ref -> ref.replaceAll("([a-zA-Z0-9._#]+/)*", "")).orElse(""))).orElse("");
    }

    @NotNull
    private static String exampleName(@NotNull String prefix, @NotNull String key) {
        if ("example".equalsIgnoreCase(key)) {
            return prefix;
        }
        return prefix + "-" + key;
    }

    @Generated
    private ExampleExtractors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

