/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.TypeInstance;
import org.raml.v2.api.model.v10.datamodel.TypeInstanceProperty;

class ExampleUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    private ExampleUtils() {
        throw new AssertionError((Object)"Private constructor");
    }

    public static Object getExampleObject(ExampleSpec ramlExample, boolean convertJsonExamplesToYaml) {
        if (ramlExample == null) {
            return null;
        }
        TypeInstance structuredValue = ramlExample.structuredValue();
        Iterator iterator = structuredValue.properties().iterator();
        if (iterator.hasNext()) {
            TypeInstanceProperty property = (TypeInstanceProperty)iterator.next();
            if (property.isArray().booleanValue()) {
                return property.values().stream().map(TypeInstance::value).collect(Collectors.toList());
            }
            return property.value().value();
        }
        Object value = ramlExample.structuredValue() != null ? (ramlExample.structuredValue().value() != null ? ExampleUtils.prettyPrint(ramlExample.structuredValue().value().toString(), convertJsonExamplesToYaml) : null) : (ramlExample.value() != null ? ExampleUtils.prettyPrint(ramlExample.value(), convertJsonExamplesToYaml) : null);
        return value;
    }

    private static Object prettyPrint(String example, boolean convertJsonExamplesToYaml) {
        try {
            Object json = mapper.readValue(example, Object.class);
            if (convertJsonExamplesToYaml) {
                return json;
            }
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
        }
        catch (IOException e) {
            return example;
        }
    }
}

