/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.loader;

import com.backbase.oss.boat.loader.CachingResourceUriCallback;
import com.backbase.oss.boat.loader.ContentItem;
import com.backbase.oss.boat.loader.RamlLoaderException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;

public class CachingResourceLoader
implements ResourceLoaderExtended {
    private Map<String, ContentItem> nameToContent = new HashMap<String, ContentItem>();
    private Map<String, ContentItem> contentToName = new HashMap<String, ContentItem>();
    private ResourceLoaderExtended resourceLoader;
    private ObjectMapper jsonMapper = new ObjectMapper();

    public CachingResourceLoader(ResourceLoaderExtended resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private InputStream cacheContent(URI foundUri, String resourceName, InputStream inputStream) {
        InputStream inputStream2;
        block9: {
            if (inputStream == null) {
                return null;
            }
            InputStream in = inputStream;
            try {
                String content = IOUtils.toString((InputStream)in, (String)StandardCharsets.UTF_8.name());
                content = this.normaliseJsonRefs(foundUri, resourceName, content);
                ContentItem contentItem = new ContentItem(foundUri, content, resourceName);
                this.nameToContent.put(resourceName, contentItem);
                this.contentToName.put(content, contentItem);
                inputStream2 = IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RamlLoaderException("Failed to cache content", e);
                }
            }
            in.close();
        }
        return inputStream2;
    }

    @Nullable
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        if (this.nameToContent.containsKey(resourceName)) {
            ContentItem contentItem = this.nameToContent.get(resourceName);
            if (callback != null) {
                callback.onResourceFound(contentItem.getFoundUri());
            }
            return IOUtils.toInputStream((String)contentItem.getContent(), (Charset)StandardCharsets.UTF_8);
        }
        CachingResourceUriCallback myCallback = new CachingResourceUriCallback(callback);
        InputStream inputStream = this.resourceLoader.fetchResource(resourceName, (ResourceUriCallback)myCallback);
        return this.cacheContent(myCallback.getResourceUri(), resourceName, inputStream);
    }

    public String normaliseJsonRefs(URI foundUri, String resourceName, String content) {
        if (!resourceName.endsWith(".json")) {
            return content;
        }
        try {
            JsonNode schema = this.jsonMapper.readTree(content);
            List refs = schema.findParents("$ref");
            for (JsonNode ref : refs) {
                String uriString = ref.findValue("$ref").asText();
                URI refUri = URI.create(uriString);
                if (refUri.isAbsolute()) continue;
                URI resolvedUri = foundUri.resolve(refUri).normalize();
                ((ObjectNode)ref).put("$ref", resolvedUri.toString());
            }
            return schema.toString();
        }
        catch (IOException e) {
            throw new RamlLoaderException("Failed to normalize json references", e);
        }
    }

    public URI getUriCallBackParam() {
        return this.resourceLoader != null ? this.resourceLoader.getUriCallBackParam() : null;
    }
}

