/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.transformers.Transformer;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deprecator
implements Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Deprecator.class);

    @Override
    public OpenAPI transform(OpenAPI openAPI, Map<String, Object> options) {
        openAPI.getPaths().forEach((s, pathItem) -> {
            if (this.isGetDeprecated((PathItem)pathItem)) {
                pathItem.setGet(null);
            }
            if (pathItem.getDelete() != null && pathItem.getDelete().getDeprecated() != null && pathItem.getDelete().getDeprecated().booleanValue()) {
                pathItem.setDelete(null);
            }
            if (pathItem.getPost() != null && pathItem.getPost().getDeprecated() != null && pathItem.getPost().getDeprecated().booleanValue()) {
                pathItem.setPost(null);
            }
            if (pathItem.getPut() != null && pathItem.getPut().getDeprecated() != null && pathItem.getPut().getDeprecated().booleanValue()) {
                pathItem.setPut(null);
            }
            if (pathItem.getPatch() != null && pathItem.getPatch().getDeprecated() != null && pathItem.getPatch().getDeprecated().booleanValue()) {
                pathItem.setPatch(null);
            }
            this.transformOperations((PathItem)pathItem);
        });
        openAPI.getComponents().getSchemas().values().forEach(Deprecator::removeDeprecatedProperties);
        return openAPI;
    }

    private void transformOperations(PathItem pathItem) {
        pathItem.readOperations().forEach(operation -> {
            RequestBody requestBody;
            if (operation.getParameters() != null) {
                operation.setParameters(operation.getParameters().stream().filter(parameter -> !Boolean.TRUE.equals(parameter.getDeprecated())).collect(Collectors.toList()));
            }
            if ((requestBody = operation.getRequestBody()) != null && requestBody.getContent() != null) {
                Content content = requestBody.getContent();
                Deprecator.removeDeprecatedContent(content);
            }
            operation.getResponses().forEach((s1, apiResponse) -> {
                if (apiResponse.getContent() != null) {
                    Content content = apiResponse.getContent();
                    Deprecator.removeDeprecatedContent(content);
                }
            });
        });
    }

    private boolean isGetDeprecated(PathItem pathItem) {
        return pathItem.getGet() != null && pathItem.getGet().getDeprecated() != null && pathItem.getGet().getDeprecated() != false;
    }

    private static void removeDeprecatedContent(Content content) {
        ArrayList values = new ArrayList(content.values());
        for (MediaType value : values) {
            Deprecator.removeDeprecatedProperties(value.getSchema());
        }
    }

    private static void removeDeprecatedProperties(Schema schema) {
        if (schema == null) {
            log.warn("Some weird stuff is going on...");
            return;
        }
        if (schema.getProperties() != null) {
            LinkedHashMap properties = new LinkedHashMap();
            schema.getProperties().forEach((propertyNameObject, propertySchemaObject) -> {
                String propertyName = (String)propertyNameObject;
                Schema propertySchema = (Schema)propertySchemaObject;
                if (Boolean.TRUE.equals(propertySchema.getDeprecated())) {
                    log.debug("Property: {} is deprecated", (Object)propertyName);
                } else {
                    properties.put(propertyName, propertySchema);
                    Deprecator.removeDeprecatedProperties(propertySchema);
                }
            });
            schema.setProperties(properties);
        }
    }
}

