/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.serializer.SerializerUtils;
import com.backbase.oss.boat.transformers.Transformer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.CaseFormat;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseFormatTransformer
implements Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CaseFormatTransformer.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public OpenAPI transform(OpenAPI openAPI, Map<String, Object> options) {
        CaseFormat caseFormatFrom = null;
        CaseFormat caseFormatTo = null;
        Map<String, String> overrides = new HashMap<String, String>();
        if (options != null) {
            caseFormatFrom = (CaseFormat)options.get("caseFormatFrom");
            caseFormatTo = (CaseFormat)options.get("caseFormatTo");
            overrides = (Map)options.get("overrides");
        }
        if (caseFormatFrom == null && caseFormatTo == null) {
            this.transformCamelCaseToSnakeCase(openAPI);
        } else {
            if (overrides == null) {
                overrides = new HashMap();
            }
            this.transform(openAPI, caseFormatFrom, caseFormatTo, overrides);
        }
        return openAPI;
    }

    public String transformCamelCaseToSnakeCase(OpenAPI openAPI) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put("u_r_i", "uri");
        overrides.put("u_r_l", "url");
        overrides.put("i_b_a_n", "iban");
        overrides.put("b_b_a_n", "bban");
        overrides.put("b_i_c", "bic");
        return this.transform(openAPI, CaseFormat.LOWER_CAMEL, CaseFormat.LOWER_UNDERSCORE, new HashMap<String, String>());
    }

    public String transform(OpenAPI openAPI, CaseFormat caseFormatFrom, CaseFormat caseFormatTo, Map<String, String> overrides) {
        openAPI.getPaths().forEach((s, pathItem) -> pathItem.readOperations().stream().filter(operation -> operation.getParameters() != null).forEach(operation -> {
            List filtered = operation.getParameters().stream().map(parameter -> this.transformParameter(caseFormatFrom, caseFormatTo, overrides, (Parameter)parameter)).collect(Collectors.toList());
            operation.setParameters(filtered);
            RequestBody requestBody = operation.getRequestBody();
            if (requestBody != null && requestBody.getContent() != null) {
                this.transformRequestBody(caseFormatFrom, caseFormatTo, overrides, requestBody);
            }
            operation.getResponses().forEach((s1, apiResponse) -> {
                if (apiResponse.getContent() != null) {
                    this.transformResponse(caseFormatFrom, caseFormatTo, overrides, (ApiResponse)apiResponse);
                }
            });
        }));
        openAPI.getComponents().getSchemas().forEach((s, schema) -> this.transform((Schema)schema, caseFormatFrom, caseFormatTo, overrides));
        return SerializerUtils.toYamlString(openAPI);
    }

    private void transformResponse(CaseFormat caseFormatFrom, CaseFormat caseFormatTo, Map<String, String> overrides, ApiResponse apiResponse) {
        ArrayList values = new ArrayList(apiResponse.getContent().values());
        for (MediaType value : values) {
            if (value.getSchema() == null) continue;
            this.transform(value.getSchema(), caseFormatFrom, caseFormatTo, overrides);
            if (!(value.getExample() instanceof String)) continue;
            value.setExample((Object)this.snakeExample(value.getExample().toString(), caseFormatFrom, caseFormatTo, overrides));
        }
    }

    private void transformRequestBody(CaseFormat caseFormatFrom, CaseFormat caseFormatTo, Map<String, String> overrides, RequestBody requestBody) {
        ArrayList values = new ArrayList(requestBody.getContent().values());
        for (MediaType value : values) {
            this.transform(value.getSchema(), caseFormatFrom, caseFormatTo, overrides);
            if (!(value.getExample() instanceof String)) continue;
            value.setExample((Object)this.snakeExample(value.getExample().toString(), caseFormatFrom, caseFormatTo, overrides));
        }
    }

    private Parameter transformParameter(CaseFormat caseFormatFrom, CaseFormat caseFormatTo, Map<String, String> overrides, Parameter parameter) {
        if (parameter instanceof QueryParameter) {
            parameter.setName(this.transform(parameter.getName(), caseFormatFrom, caseFormatTo, overrides));
        }
        return parameter;
    }

    private void transform(Schema schema, CaseFormat from, CaseFormat to, Map<String, String> overrides) {
        if (schema.getProperties() != null) {
            log.debug("Processing schema: {}", (Object)schema.getName());
            LinkedHashMap properties = new LinkedHashMap();
            schema.getProperties().forEach((propertyNameObject, propertySchemaObject) -> {
                String propertyName = (String)propertyNameObject;
                Schema propertySchema = (Schema)propertySchemaObject;
                String newName = this.transform(propertyName, from, to, overrides);
                log.debug("Renaming property: {} to {}", (Object)propertyName, (Object)newName);
                properties.put(newName, propertySchema);
                this.transform(propertySchema, from, to, overrides);
            });
            schema.setProperties(properties);
        }
        if (schema.getExample() instanceof String) {
            String fixedExample = this.snakeExample(schema.getExample().toString(), from, to, overrides);
            schema.setExample((Object)fixedExample);
        }
    }

    String transform(String name, CaseFormat from, CaseFormat to, Map<String, String> overrides) {
        String result = from.to(to, name);
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            String fromKeyword = entry.getKey();
            String toKeyword = entry.getValue();
            result = result.replaceAll(fromKeyword, toKeyword);
        }
        return result;
    }

    private String snakeExample(String example, CaseFormat from, CaseFormat to, Map<String, String> overrides) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(example);
            this.transform(jsonNode, from, to, overrides);
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (IOException e) {
            log.debug("not valid json. nothing to rename");
            return example;
        }
    }

    private void transform(JsonNode json, CaseFormat from, CaseFormat to, Map<String, String> overrides) {
        if (json.isObject()) {
            ObjectNode objectNode = (ObjectNode)json;
            HashSet toBeRemoved = new HashSet();
            LinkedHashMap renamedFields = new LinkedHashMap();
            objectNode.fields().forEachRemaining(field -> {
                String newName = this.transform((String)field.getKey(), from, to, overrides);
                if (((JsonNode)field.getValue()).isObject()) {
                    this.transform((JsonNode)field.getValue(), from, to, overrides);
                }
                if (((JsonNode)field.getValue()).isArray()) {
                    ((JsonNode)field.getValue()).forEach(jsonNode -> this.transform((JsonNode)jsonNode, from, to, overrides));
                }
                renamedFields.put(newName, (JsonNode)field.getValue());
                toBeRemoved.add((String)field.getKey());
            });
            objectNode.remove(toBeRemoved);
            objectNode.setAll(renamedFields);
        }
        if (json.isArray()) {
            json.forEach(jsonNode -> this.transform((JsonNode)jsonNode, from, to, overrides));
        }
    }
}

