/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.transformers.Transformer;
import com.backbase.oss.boat.transformers.TransformerException;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DereferenceComponentsPropertiesTransformer
implements Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DereferenceComponentsPropertiesTransformer.class);
    private static final String COMPONENTS_SCHEMAS_PATH = "#/components/schemas/";
    private final Map<String, Schema> resolvedShemas = new HashMap<String, Schema>();

    @Override
    public OpenAPI transform(OpenAPI openAPI, Map<String, Object> options) {
        if (openAPI.getComponents() == null || openAPI.getComponents().getSchemas() == null) {
            log.debug("Nothing to dereference.");
            return openAPI;
        }
        openAPI.getComponents().getSchemas().forEach((name, schema) -> this.deferenceSchema((Schema)schema, openAPI, (String)name));
        return openAPI;
    }

    private void deferenceSchema(Schema schema, OpenAPI openAPI, String crumb) {
        log.debug("Dereference Schema: {}", (Object)crumb);
        if (!this.resolvedShemas.containsKey(crumb)) {
            if (schema instanceof ComposedSchema) {
                this.deferenceAllOf((ComposedSchema)schema, openAPI, crumb);
            }
            if (schema instanceof ArraySchema) {
                this.dereferenceItems((ArraySchema)schema, openAPI, crumb);
            }
            if (schema.getProperties() != null) {
                this.dereferenceProperties(schema, openAPI, crumb);
            }
            this.resolvedShemas.put(crumb, schema);
        } else {
            log.debug("Already dereferenced: {}", (Object)crumb);
        }
    }

    private void dereferenceProperties(Schema schema, OpenAPI openAPI, String crumb) {
        HashMap replacements = Maps.newHashMap();
        for (Map.Entry entry : schema.getProperties().entrySet()) {
            Schema propertySchema = (Schema)entry.getValue();
            if (propertySchema.get$ref() != null && !this.resolvedShemas.containsKey(propertySchema.get$ref())) {
                log.debug(crumb + " : Replacing property {} with schema {}", entry.getKey(), (Object)propertySchema.get$ref());
                Schema referencedSchema = this.getSchemaByInternalReference(propertySchema.get$ref(), openAPI);
                replacements.put((String)entry.getKey(), referencedSchema);
                propertySchema = referencedSchema;
                this.resolvedShemas.put(propertySchema.get$ref(), referencedSchema);
            }
            this.deferenceSchema(propertySchema, openAPI, crumb + "/" + (String)entry.getKey());
        }
        log.debug(crumb + " : Replacing {} properties", (Object)replacements.size());
        schema.getProperties().putAll(replacements);
    }

    private void dereferenceItems(ArraySchema schema, OpenAPI openAPI, String crumb) {
        ArraySchema arraySchema = schema;
        if (arraySchema.getItems().get$ref() != null) {
            log.debug(crumb + " : Replacing items with schema {}", (Object)arraySchema.getItems().get$ref());
            Schema referencedSchema = this.getSchemaByInternalReference(arraySchema.getItems().get$ref(), openAPI);
            arraySchema.setItems(referencedSchema);
        }
        this.deferenceSchema(arraySchema.getItems(), openAPI, crumb + "/items");
    }

    private void deferenceAllOf(ComposedSchema schema, OpenAPI openAPI, String crumb) {
        if (schema.getAllOf() == null) {
            log.warn(crumb + " composite schema without all-of not dereferenced.");
            return;
        }
        schema.getAllOf().stream().forEach(ref -> this.apply((Schema)ref, schema, openAPI));
        schema.setAllOf(null);
    }

    private void apply(Schema ref, ComposedSchema schema, OpenAPI openAPI) {
        Schema refSchema = ref;
        if (ref.get$ref() != null) {
            refSchema = this.getSchemaByInternalReference(ref.get$ref(), openAPI);
        }
        if (refSchema.getProperties() != null) {
            if (schema.getProperties() == null) {
                schema.setProperties((Map)Maps.newHashMap());
            }
            schema.getProperties().putAll(refSchema.getProperties());
        }
        if (refSchema.getRequired() != null) {
            if (schema.getRequired() == null) {
                schema.setRequired(refSchema.getRequired());
            } else {
                schema.getRequired().addAll(refSchema.getRequired());
            }
        }
    }

    private Schema getSchemaByInternalReference(String internalReference, OpenAPI openAPI) {
        if (!internalReference.startsWith(COMPONENTS_SCHEMAS_PATH)) {
            throw new IllegalArgumentException(String.format("Not an internal ref %s", internalReference));
        }
        String[] parts = StringUtils.removeStart((String)internalReference, (String)COMPONENTS_SCHEMAS_PATH).split("/");
        Schema schema = (Schema)openAPI.getComponents().getSchemas().get(parts[0]);
        if (schema == null) {
            throw new TransformerException(String.format("No component schema found by name %s", internalReference));
        }
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].equals("properties")) {
                schema = (Schema)schema.getProperties().get(parts[++i]);
                continue;
            }
            if (parts[i].equals("items")) {
                schema = ((ArraySchema)schema).getItems();
                continue;
            }
            throw new TransformerException("Unable to process $ref " + internalReference);
        }
        if (schema.get$ref() != null) {
            return this.getSchemaByInternalReference(schema.get$ref(), openAPI);
        }
        return schema;
    }
}

