/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class OpenApiStreamUtil {
    static Stream<Schema> streamPathSchemas(OpenAPI openAPI) {
        return openAPI.getPaths().values().stream().flatMap(OpenApiStreamUtil::streamOperations).flatMap(OpenApiStreamUtil::streamSchemas);
    }

    static Stream<Schema> streamSchemas(OpenAPI openAPI) {
        List firstLevelSchemas = Stream.of(openAPI.getPaths().values().stream().flatMap(OpenApiStreamUtil::streamOperations).flatMap(OpenApiStreamUtil::streamSchemas), openAPI.getComponents().getSchemas().values().stream()).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
        return Stream.of(firstLevelSchemas.stream(), firstLevelSchemas.stream().map(OpenApiStreamUtil::stream).reduce(Stream::concat).orElse(Stream.empty())).reduce(Stream::concat).orElse(Stream.empty());
    }

    private static Stream<Schema> streamSchemas(Operation operation) {
        return Stream.of(OpenApiStreamUtil.nullSafeContent(operation).values().stream().map(MediaType::getSchema).filter(Objects::nonNull), OpenApiStreamUtil.nullSafeApiResponses(operation).stream().map(ApiResponse::getContent).filter(Objects::nonNull).flatMap(OpenApiStreamUtil::streamContentSchemas)).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private static Stream<Schema> stream(Schema schema) {
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            return OpenApiStreamUtil.stream(arraySchema.getItems());
        }
        if (schema.getProperties() != null) {
            return schema.getProperties().values().stream().map(OpenApiStreamUtil::stream).reduce(Stream::concat).orElse(Stream.empty());
        }
        return Stream.of(schema);
    }

    private static Stream<Schema> streamContentSchemas(Content content) {
        return content.values().stream().map(MediaType::getSchema).filter(Objects::nonNull);
    }

    static Stream<Operation> streamOperations(PathItem pathItem) {
        return Stream.of(pathItem.getGet(), pathItem.getPut(), pathItem.getPost(), pathItem.getDelete(), pathItem.getPatch());
    }

    static Content nullSafeContent(Operation operation) {
        return operation != null && operation.getRequestBody() != null && operation.getRequestBody().getContent() != null ? operation.getRequestBody().getContent() : new Content();
    }

    static Collection<ApiResponse> nullSafeApiResponses(Operation operation) {
        return operation != null && operation.getResponses() != null ? operation.getResponses().values() : Collections.emptyList();
    }

    @Generated
    private OpenApiStreamUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

