/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.transformers.Transformer;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.License;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseAdder
implements Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseAdder.class);
    private final String licenseName;
    private final String licenseUrl;

    public LicenseAdder(String licenseName, String licenseUrl) {
        this.licenseName = licenseName;
        this.licenseUrl = licenseUrl;
    }

    @Override
    public OpenAPI transform(OpenAPI openAPI, Map<String, Object> options) {
        if (openAPI.getInfo().getLicense() == null) {
            openAPI.getInfo().setLicense(new License().name(this.licenseName).url(this.licenseUrl));
            log.info("Adding License: {} with url: {} to Schema: {}", new Object[]{this.licenseName, this.licenseUrl, openAPI.getInfo().getTitle()});
        }
        return openAPI;
    }
}

