/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.Utils;
import com.backbase.oss.boat.transformers.Transformer;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Normaliser
implements Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Normaliser.class);

    @Override
    public OpenAPI transform(OpenAPI openAPI, Map<String, Object> options) {
        openAPI.getPaths().forEach((s, pathItem) -> pathItem.readOperations().forEach(operation -> {
            RequestBody requestBody = operation.getRequestBody();
            this.normalizeRequest((String)s, requestBody);
            operation.getResponses().forEach(this::normalizeResponse);
        }));
        openAPI.getComponents().getRequestBodies().forEach(this::normalizeRequest);
        openAPI.getComponents().getResponses().forEach(this::normalizeResponse);
        return openAPI;
    }

    private void normalizeResponse(String s, ApiResponse apiResponse) {
        if (apiResponse != null && apiResponse.getContent() != null) {
            log.debug("Normalizing Response Examples in: {}", (Object)s);
            apiResponse.getContent().forEach((key, value) -> this.normalizeExampleNames((MediaType)value));
        }
    }

    private void normalizeRequest(String s, RequestBody requestBody) {
        if (requestBody != null && requestBody.getContent() != null) {
            log.debug("Normalizing Request Examples in: {}", (Object)s);
            requestBody.getContent().forEach((key, value) -> this.normalizeExampleNames((MediaType)value));
        }
    }

    public void normalizeExampleNames(MediaType mediaType) {
        Map examples = mediaType.getExamples();
        if (mediaType.getExamples() != null) {
            LinkedHashMap normalizedExamples = new LinkedHashMap();
            examples.forEach((name, example) -> {
                String normalizedName = Utils.normalizeSchemaName(name);
                log.debug("Normalizing name: {} to: {}", name, (Object)normalizedName);
                normalizedExamples.put(normalizedName, example);
            });
            mediaType.setExamples(normalizedExamples);
        }
    }
}

