/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.transformers.OpenApiStreamUtil;
import com.backbase.oss.boat.transformers.Transformer;
import com.backbase.oss.boat.transformers.TransformerException;
import com.google.common.collect.ImmutableSet;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnAliasTransformer
implements Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnAliasTransformer.class);
    private static final Set<String> NON_ALIAS_TYPES = ImmutableSet.builder().add((Object[])new String[]{"object", "array", "map"}).build();

    @Override
    public OpenAPI transform(OpenAPI openAPI, Map<String, Object> options) {
        OpenApiStreamUtil.streamSchemas(openAPI).forEach(schema -> this.unAliasType((Schema)schema, openAPI));
        return openAPI;
    }

    private void unAliasType(Schema schema, OpenAPI openAPI) {
        log.debug("Processing {}, ref {}", (Object)schema.getName(), (Object)schema.get$ref());
        if (schema.get$ref() == null) {
            return;
        }
        if (!schema.get$ref().startsWith("#/components/schemas")) {
            log.warn("Only unalias dereferenced schema. Cannot process reference {} in {}", (Object)schema.get$ref(), (Object)schema.getName());
            return;
        }
        Schema referredSchema = schema;
        int count = 0;
        while (referredSchema.get$ref() != null) {
            referredSchema = (Schema)openAPI.getComponents().getSchemas().get(RefUtils.extractSimpleName((String)referredSchema.get$ref()).getLeft());
            if (count++ <= 20) continue;
            throw new TransformerException("Did not resolve " + schema.get$ref() + " after following 20 refs.");
        }
        if (!UnAliasTransformer.isAliasOfSimpleTypes(referredSchema)) {
            return;
        }
        UnAliasTransformer.unAlias(schema, referredSchema);
    }

    private static void unAlias(Schema schema, Schema alias) {
        log.debug("{} refers to alias type {}", (Object)schema.getName(), (Object)schema.get$ref());
        schema.set$ref(null);
        schema.setType(alias.getType());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getName(), arg_0 -> ((Schema)schema).setName(arg_0), () -> ((Schema)alias).getName());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getTitle(), arg_0 -> ((Schema)schema).setTitle(arg_0), () -> ((Schema)alias).getTitle());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMultipleOf(), arg_0 -> ((Schema)schema).setMultipleOf(arg_0), () -> ((Schema)alias).getMultipleOf());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMaximum(), arg_0 -> ((Schema)schema).setMaximum(arg_0), () -> ((Schema)alias).getMaximum());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getExclusiveMaximum(), arg_0 -> ((Schema)schema).setExclusiveMaximum(arg_0), () -> ((Schema)alias).getExclusiveMaximum());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMinimum(), arg_0 -> ((Schema)schema).setMinimum(arg_0), () -> ((Schema)alias).getMinimum());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getExclusiveMinimum(), arg_0 -> ((Schema)schema).setExclusiveMinimum(arg_0), () -> ((Schema)alias).getExclusiveMinimum());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMaxLength(), arg_0 -> ((Schema)schema).setMaxLength(arg_0), () -> ((Schema)alias).getMaxLength());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMinLength(), arg_0 -> ((Schema)schema).setMinLength(arg_0), () -> ((Schema)alias).getMinLength());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getPattern(), arg_0 -> ((Schema)schema).setPattern(arg_0), () -> ((Schema)alias).getPattern());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMaxItems(), arg_0 -> ((Schema)schema).setMaxItems(arg_0), () -> ((Schema)alias).getMaxItems());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMinItems(), arg_0 -> ((Schema)schema).setMinItems(arg_0), () -> ((Schema)alias).getMinItems());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getUniqueItems(), arg_0 -> ((Schema)schema).setUniqueItems(arg_0), () -> ((Schema)alias).getUniqueItems());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMaxProperties(), arg_0 -> ((Schema)schema).setMaxProperties(arg_0), () -> ((Schema)alias).getMaxProperties());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getMinProperties(), arg_0 -> ((Schema)schema).setMinProperties(arg_0), () -> ((Schema)alias).getMinProperties());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getRequired(), arg_0 -> ((Schema)schema).setRequired(arg_0), () -> ((Schema)alias).getRequired());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getNot(), arg_0 -> ((Schema)schema).setNot(arg_0), () -> ((Schema)alias).getNot());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getProperties(), arg_0 -> ((Schema)schema).setProperties(arg_0), () -> ((Schema)alias).getProperties());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getAdditionalProperties(), arg_0 -> ((Schema)schema).setAdditionalProperties(arg_0), () -> ((Schema)alias).getAdditionalProperties());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getDescription(), arg_0 -> ((Schema)schema).setDescription(arg_0), () -> ((Schema)alias).getDescription());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getFormat(), arg_0 -> ((Schema)schema).setFormat(arg_0), () -> ((Schema)alias).getFormat());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getNullable(), arg_0 -> ((Schema)schema).setNullable(arg_0), () -> ((Schema)alias).getNullable());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getReadOnly(), arg_0 -> ((Schema)schema).setReadOnly(arg_0), () -> ((Schema)alias).getReadOnly());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getWriteOnly(), arg_0 -> ((Schema)schema).setWriteOnly(arg_0), () -> ((Schema)alias).getWriteOnly());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getExample(), arg_0 -> ((Schema)schema).setExample(arg_0), () -> ((Schema)alias).getExample());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getExternalDocs(), arg_0 -> ((Schema)schema).setExternalDocs(arg_0), () -> ((Schema)alias).getExternalDocs());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getDeprecated(), arg_0 -> ((Schema)schema).setDeprecated(arg_0), () -> ((Schema)alias).getDeprecated());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getXml(), arg_0 -> ((Schema)schema).setXml(arg_0), () -> ((Schema)alias).getXml());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getExtensions(), arg_0 -> ((Schema)schema).setExtensions(arg_0), () -> ((Schema)alias).getExtensions());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getEnum(), arg_0 -> ((Schema)schema).setEnum(arg_0), () -> ((Schema)alias).getEnum());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getDiscriminator(), arg_0 -> ((Schema)schema).setDiscriminator(arg_0), () -> ((Schema)alias).getDiscriminator());
        UnAliasTransformer.dontOverride(() -> ((Schema)schema).getExampleSetFlag(), arg_0 -> ((Schema)schema).setExampleSetFlag(arg_0), () -> ((Schema)alias).getExampleSetFlag());
    }

    private static <T> void dontOverride(Supplier<T> oGet, Consumer<T> oSet, Supplier<T> aGet) {
        if (oGet.get() != null) {
            return;
        }
        oSet.accept(aGet.get());
    }

    private static boolean isAliasOfSimpleTypes(Schema schema) {
        if (schema.getType() == null) {
            return schema.getProperties() == null || schema.getProperties().isEmpty();
        }
        return !NON_ALIAS_TYPES.contains(schema.getType());
    }
}

