/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.google.common.base.CaseFormat;
import com.google.common.collect.BiMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
        throw new UnsupportedOperationException("private constructor");
    }

    static boolean isDirectory(URL base, String ref) {
        URI uri = base.toURI().resolve(ref);
        File file = new File(uri.toURL().getFile());
        boolean directory = file.isDirectory();
        log.trace("isDirectory: {} $ref: {} = {}", new Object[]{base, ref, directory});
        return directory;
    }

    static URL getAbsoluteReferenceParent(String absoluteReference) {
        return Utils.getAbsoluteReferenceParent(new URL(absoluteReference));
    }

    static URL getAbsoluteReferenceParent(URL absoluteReference) {
        URI uri = absoluteReference.toURI();
        if (uri.getFragment() != null) {
            return uri.toURL();
        }
        URI parent = uri.getPath().endsWith("/") ? uri.resolve("..") : uri.resolve(".");
        return parent.toURL();
    }

    static String getSchemaNameFromReference(URL absoluteReference, String parentSchemaName, BiMap<String, String> referenceNames) {
        return Utils.getSchemaNameFromReference(absoluteReference.toString(), parentSchemaName, referenceNames);
    }

    static String getSchemaNameFromReference(String reference, String parentSchemaName, BiMap<String, String> referenceNames) {
        Object name;
        Object proposedName = Utils.getProposedSchemaName(reference);
        String existingName = (String)referenceNames.get((Object)reference);
        String existingRef = (String)referenceNames.inverse().get(proposedName);
        if (existingName == null && existingRef == null) {
            try {
                referenceNames.put((Object)reference, proposedName);
            }
            catch (IllegalArgumentException ex) {
                log.error("thingy already exists");
            }
            name = proposedName;
        } else if (existingName != null && existingRef != null && existingName.equals(proposedName) && existingRef.equals(reference)) {
            name = proposedName;
        } else if (Utils.isUrl(reference)) {
            URL parent = Utils.getAbsoluteReferenceParent(reference);
            String parentReference = StringUtils.stripEnd((String)parent.toString(), (String)"/");
            String parentName = Utils.getProposedSchemaName(parentReference);
            String newName = parentName + (String)proposedName;
            log.warn("Schema Name already exists for: {} Using: {}", proposedName, (Object)newName);
            proposedName = newName;
            referenceNames.put((Object)reference, proposedName);
            name = proposedName;
        } else {
            String newName = (String)proposedName + "Duplicate";
            log.warn("Schema Name already exists for{} Using: {}", proposedName, (Object)newName);
            referenceNames.put((Object)reference, (Object)newName);
            name = newName;
        }
        return name;
    }

    protected static String getProposedSchemaName(String absoluteReference) {
        String proposedName = absoluteReference;
        if (proposedName.contains("/")) {
            proposedName = StringUtils.substringAfterLast((String)proposedName, (String)"/");
        }
        proposedName = StringUtils.substringBeforeLast((String)proposedName, (String)".");
        return Utils.normalizeSchemaName(proposedName);
    }

    public static String normalizeSchemaName(String name) {
        name = name.contains("-") ? CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name) : CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, name);
        name = name.replaceAll("[^A-Za-z0-9]", "");
        name = StringUtils.deleteWhitespace((String)name);
        return name;
    }

    protected static boolean isUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String[] selectInputs(Path inputPath, String glob) throws IOException {
        PathMatcher matcher = inputPath.getFileSystem().getPathMatcher("glob:" + glob);
        try (Stream<Path> paths = Files.list(inputPath);){
            String[] stringArray = (String[])paths.map(inputPath::relativize).filter(matcher::matches).map(Path::toString).toArray(String[]::new);
            return stringArray;
        }
    }
}

