/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.example.NamedExample;
import com.backbase.oss.boat.transformers.ExampleExtractors;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OpenAPIExtractor {
    @NotNull
    private final OpenAPI openApi;

    public OpenAPIExtractor(@NotNull OpenAPI openApi) {
        this.openApi = openApi;
    }

    public List<NamedExample> extractInlineExamples() {
        Collection pathItems = Optional.ofNullable(this.openApi.getPaths()).orElse(new Paths()).values();
        List pathItemParamsExamples = pathItems.stream().filter(pathItem -> pathItem.getParameters() != null).flatMap(pathItem -> pathItem.getParameters().stream()).flatMap(parameter -> ExampleExtractors.parameterExamples(parameter).stream()).collect(Collectors.toList());
        List ops = pathItems.stream().flatMap(pathItem -> pathItem.readOperations().stream()).collect(Collectors.toList());
        List opParamsExamples = ops.stream().filter(operation -> operation.getParameters() != null).flatMap(operation -> operation.getParameters().stream()).flatMap(parameter -> ExampleExtractors.parameterExamples(parameter).stream()).collect(Collectors.toList());
        List opRequestBodiesExamples = ops.stream().filter(operation -> operation.getRequestBody() != null).filter(operation -> operation.getRequestBody().getContent() != null).flatMap(operation -> ExampleExtractors.contentExamples(operation.getRequestBody().getContent()).stream()).collect(Collectors.toList());
        List opResponses = ops.stream().filter(operation -> operation.getResponses() != null).flatMap(operation -> operation.getResponses().values().stream()).collect(Collectors.toList());
        List opResponsesContentExamples = opResponses.stream().filter(apiResponse -> apiResponse.getContent() != null).flatMap(apiResponse -> ExampleExtractors.contentExamples(apiResponse.getContent()).stream()).collect(Collectors.toList());
        List opResponsesHeadersExamples = opResponses.stream().filter(apiResponse -> apiResponse.getHeaders() != null).flatMap(apiResponse -> apiResponse.getHeaders().entrySet().stream()).flatMap(headerEntry -> ExampleExtractors.headerExamples((Header)headerEntry.getValue()).stream()).collect(Collectors.toList());
        List opResponseLinksExamples = opResponses.stream().filter(apiResponse -> apiResponse.getLinks() != null).flatMap(apiResponse -> apiResponse.getLinks().values().stream()).filter(link -> link.getHeaders() != null).flatMap(link -> link.getHeaders().entrySet().stream()).flatMap(headerEntry -> ExampleExtractors.headerExamples((Header)headerEntry.getValue()).stream()).collect(Collectors.toList());
        Collection componentsExamples = Optional.ofNullable(this.openApi.getComponents()).filter(components -> components.getExamples() != null).map(Components::getExamples).map(Map::entrySet).orElse(Collections.emptyMap().entrySet()).stream().map(entry -> new NamedExample((String)entry.getKey(), (Example)entry.getValue())).collect(Collectors.toList());
        Collection componentsHeadersExamples = Optional.ofNullable(this.openApi.getComponents()).filter(components -> components.getHeaders() != null).map(Components::getHeaders).orElse(Collections.emptyMap()).entrySet().stream().flatMap(headerEntry -> ExampleExtractors.headerExamples((Header)headerEntry.getValue()).stream()).collect(Collectors.toList());
        Collection componentsLinksExamples = ((Collection)Optional.ofNullable(this.openApi.getComponents()).filter(components -> components.getLinks() != null).map(Components::getLinks).map(Map::values).orElse(Collections.emptyList())).stream().filter(link -> link.getHeaders() != null).flatMap(link -> link.getHeaders().entrySet().stream()).flatMap(headerEntry -> ExampleExtractors.headerExamples((Header)headerEntry.getValue()).stream()).collect(Collectors.toList());
        Collection componentsParamsExamples = ((Collection)Optional.ofNullable(this.openApi.getComponents()).filter(components -> components.getHeaders() != null).map(Components::getParameters).map(Map::values).orElse(Collections.emptyList())).stream().flatMap(parameter -> ExampleExtractors.parameterExamples(parameter).stream()).collect(Collectors.toList());
        LinkedList allExamples = new LinkedList();
        allExamples.addAll(pathItemParamsExamples);
        allExamples.addAll(opParamsExamples);
        allExamples.addAll(opRequestBodiesExamples);
        allExamples.addAll(opResponsesContentExamples);
        allExamples.addAll(opResponsesHeadersExamples);
        allExamples.addAll(opResponseLinksExamples);
        allExamples.addAll(componentsExamples);
        allExamples.addAll(componentsHeadersExamples);
        allExamples.addAll(componentsLinksExamples);
        allExamples.addAll(componentsParamsExamples);
        return allExamples.stream().filter(namedExample -> namedExample.getExample().getValue() != null).collect(Collectors.toList());
    }
}

