/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.transformers.Transformer;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;

public class ExtensionFilter
implements Transformer {
    private List<String> remove = Collections.emptyList();

    @Override
    @NonNull
    public OpenAPI transform(@NonNull OpenAPI openAPI, @NonNull Map<String, Object> options) {
        if (openAPI == null) {
            throw new NullPointerException("openAPI is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArrayList<String> extensions = new ArrayList<String>(this.remove);
        Optional.ofNullable(options.get("remove")).map(Collection.class::cast).ifPresent(extensions::addAll);
        extensions.addAll(extensions.stream().filter(s -> !s.startsWith("x-")).map(s -> "x-" + s).collect(Collectors.toSet()));
        return extensions.isEmpty() ? openAPI : this.transform(openAPI, extensions);
    }

    private OpenAPI transform(OpenAPI source, Collection<String> remove) {
        ObjectMapper mapper = Yaml.mapper();
        JsonNode tree = mapper.valueToTree((Object)source);
        if (tree instanceof ContainerNode) {
            this.removeExtensions((ContainerNode)tree, remove);
        }
        return (OpenAPI)mapper.treeToValue((TreeNode)tree, OpenAPI.class);
    }

    private void removeExtensions(ContainerNode node, Collection<String> remove) {
        if (node.isObject()) {
            ((ObjectNode)node).remove(remove);
        }
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.elements(), 16), false).filter(ContainerNode.class::isInstance).map(ContainerNode.class::cast).forEach(child -> this.removeExtensions((ContainerNode)child, remove));
    }

    @Generated
    public List<String> getRemove() {
        return this.remove;
    }

    @Generated
    public void setRemove(List<String> remove) {
        this.remove = remove;
    }
}

