/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.AbstractLintMojo;
import com.backbase.oss.boat.quay.model.BoatLintReport;
import com.backbase.oss.codegen.lint.BoatLintConfig;
import com.backbase.oss.codegen.lint.BoatLintGenerator;
import java.io.File;
import java.util.List;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="lint", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class LintMojo
extends AbstractLintMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LintMojo.class);
    @Parameter(name="output", defaultValue="${project.build.directory}/boat-lint-reports")
    public File output;
    @Parameter(name="writeLintReport", defaultValue="true")
    private boolean writeLintReport;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<BoatLintReport> boatLintReports;
        block7: {
            boatLintReports = null;
            try {
                boatLintReports = this.lint();
            }
            catch (MojoExecutionException e) {
                if (!this.failOnWarning) break block7;
                throw e;
            }
        }
        if (boatLintReports == null) {
            log.warn("No reports generated for input: {}", (Object)this.inputSpec);
            return;
        }
        boolean isSingleLint = boatLintReports.size() == 1;
        boolean isFailed = false;
        for (BoatLintReport report : boatLintReports) {
            log.info("Lint report for: {}", (Object)report.getTitle());
            if (!report.hasViolations()) {
                log.info("OpenAPI: {}, is valid! No warnings!", (Object)report.getFilePath());
            } else {
                isFailed = true;
                log.warn("OpenAPI: {} has Linting issues: ", (Object)report.getFilePath());
                report.getViolations().forEach(result -> log.warn("{}", (Object)result.displayString()));
            }
            if (!this.writeLintReport) continue;
            this.generateLintReport(isSingleLint, report);
        }
        if (isFailed && this.failOnWarning) {
            throw new MojoFailureException("Linting " + this.inputSpec + " failed. Please correct the found issues and try again");
        }
    }

    private void generateLintReport(boolean isSingleLint, BoatLintReport report) {
        BoatLintConfig config = new BoatLintConfig();
        File reportOutputDir = this.getOutput();
        config.setOutputDir(reportOutputDir.toString());
        if (!isSingleLint) {
            String lintReportOutput = new File(reportOutputDir, report.getFileName()).toString();
            log.info("Writing LINT Report for: {} to: {}", (Object)report.getTitle(), (Object)lintReportOutput);
            config.setOutputDir(lintReportOutput);
        }
        BoatLintGenerator boatLintGenerator = new BoatLintGenerator(config);
        boatLintGenerator.generate(report);
    }

    private File getOutput() {
        if (this.output == null) {
            this.output = new File("./target/boat-lint");
        }
        return this.output;
    }

    public void setWriteLintReport(boolean writeLintReport) {
        this.writeLintReport = writeLintReport;
    }
}

