/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.ExportException;
import com.backbase.oss.boat.Exporter;
import com.backbase.oss.boat.ExporterOptions;
import com.backbase.oss.boat.serializer.SerializerUtils;
import com.backbase.oss.boat.transformers.AdditionalPropertiesAdder;
import com.backbase.oss.boat.transformers.Decomposer;
import com.backbase.oss.boat.transformers.Deprecator;
import com.backbase.oss.boat.transformers.LicenseAdder;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Expand;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRamlToOpenApi
extends AbstractMojo {
    protected final Map<File, OpenAPI> success = new LinkedHashMap<File, OpenAPI>();
    protected final Map<String, String> failed = new LinkedHashMap<String, String>();
    private static Logger log = LoggerFactory.getLogger(AbstractRamlToOpenApi.class);
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="includeGroupId", defaultValue="com.backbase.")
    protected String includeGroupIds;
    @Parameter(property="xLogoUrl")
    protected String xLogoUrl;
    @Parameter(property="xLogoAltText")
    protected String xLogoAltText;
    @Parameter(property="licenseName")
    protected String licenseName;
    @Parameter(property="licenseUrl")
    protected String licenseUrl;
    @Parameter(property="markdown")
    protected String markdownTop;
    @Parameter(property="markdownBottom")
    protected String markdownBottom;
    @Parameter(property="servers")
    protected List<Server> servers = Collections.emptyList();
    @Parameter(property="convertJsonExamplesToYaml", defaultValue="true")
    protected boolean convertJsonExamplesToYaml;
    @Parameter(property="addJavaTypeExtensions", defaultValue="true")
    protected boolean addJavaTypeExtensions;
    @Parameter(property="appendDeprecatedMetadataInDescription", defaultValue="true")
    protected boolean appendDeprecatedMetadataInDescription = true;
    @Parameter(property="decompose", defaultValue="true")
    protected boolean decompose;
    @Parameter(name="removeDeprecated", defaultValue="false")
    protected boolean removeDeprecated;
    @Parameter(property="includeVersionInOutputDirectory", defaultValue="true")
    protected boolean includeVersionInOutputDirectory;
    @Parameter(property="addAdditionalProperties")
    protected List<String> addAdditionalProperties = new ArrayList<String>();
    @Parameter(property="additionalPropertiesType", defaultValue="object")
    protected String additionalPropertiesType;
    @Parameter(property="continueOnError", defaultValue="true")
    protected boolean continueOnError;
    @Parameter(property="output", defaultValue="${project.build.directory}/openapi")
    protected File output = new File("${project.build.directory}/openapi");
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected MetadataResolver metadataResolver;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    protected List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="**/*-api.raml,**/api.raml")
    protected String ramlFileFilters;

    AbstractRamlToOpenApi() {
    }

    protected boolean isRamlSpec(File file) {
        return file.getName().equals("api.raml") || file.getName().endsWith("-api.raml") || file.getName().endsWith("service-api.raml") || file.getName().endsWith("client-api.raml") || file.getName().endsWith("integration-api.raml");
    }

    protected File export(String version, File ramlFile, File outputDirectory) throws ExportException, IOException {
        this.getLog().info((CharSequence)("Exporting " + ramlFile.getAbsolutePath() + " to: " + outputDirectory));
        OpenAPI openApi = this.convert(version, ramlFile);
        String yaml = SerializerUtils.toYamlString((OpenAPI)openApi);
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        File file = new File(outputDirectory, "openapi.yaml");
        Files.write(file.toPath(), yaml.getBytes(), new OpenOption[0]);
        File indexFile = new File(outputDirectory, "index.html");
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/index.html");
        String index = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
        index = org.apache.commons.lang3.StringUtils.replace((String)index, (String)"@title@", (String)openApi.getInfo().getTitle());
        Files.write(indexFile.toPath(), index.getBytes(), new OpenOption[0]);
        this.success.put(file, openApi);
        return file;
    }

    protected OpenAPI convert(String version, File ramlFile) throws ExportException {
        ExporterOptions options = new ExporterOptions().addJavaTypeExtensions(this.addJavaTypeExtensions).convertExamplesToYaml(this.convertJsonExamplesToYaml);
        if (this.removeDeprecated) {
            options.getTransformers().add(new Deprecator());
        }
        if (this.decompose) {
            options.getTransformers().add(new Decomposer());
        }
        if (!this.addAdditionalProperties.isEmpty()) {
            options.getTransformers().add(new AdditionalPropertiesAdder(this.addAdditionalProperties, this.additionalPropertiesType));
        }
        if (this.licenseName != null && this.licenseUrl != null) {
            options.getTransformers().add(new LicenseAdder(this.licenseName, this.licenseUrl));
        }
        OpenAPI openApi = Exporter.export((File)ramlFile, (ExporterOptions)options);
        this.pimpInfo(version, openApi);
        if (this.appendDeprecatedMetadataInDescription) {
            openApi.getPaths().values().forEach(pathItem -> pathItem.readOperationsMap().entrySet().stream().filter(this::isDeprecated).forEach(httpMethodOperationEntry -> {
                Operation operation = (Operation)httpMethodOperationEntry.getValue();
                Optional<String> deprecatedInformationOptional = this.generateMarkdownForDeprecationExtention(operation);
                deprecatedInformationOptional.ifPresent(deprecatedInformation -> {
                    log.debug("Inserting deprecated information: \n{}", deprecatedInformation);
                    if (operation.getDescription() == null) {
                        operation.setDescription(deprecatedInformation);
                    } else {
                        operation.setDescription(operation.getDescription() + "\n" + deprecatedInformation);
                    }
                });
                pathItem.operation((PathItem.HttpMethod)httpMethodOperationEntry.getKey(), operation);
            }));
        }
        return openApi;
    }

    private boolean isDeprecated(Map.Entry<PathItem.HttpMethod, Operation> httpMethodOperationEntry) {
        Operation value = httpMethodOperationEntry.getValue();
        return value.getDeprecated() != null && value.getDeprecated().equals(Boolean.TRUE);
    }

    private Optional<String> generateMarkdownForDeprecationExtention(Operation operation) {
        if (operation.getExtensions() == null) {
            return Optional.empty();
        }
        String deprecatedFromVersion = (String)operation.getExtensions().get("x-BbApiDeprecation-deprecatedFromVersion");
        String removedFromVersion = (String)operation.getExtensions().get("x-BbApiDeprecation-removedFromVersion");
        String reason = (String)operation.getExtensions().get("x-BbApiDeprecation-reason");
        String description = (String)operation.getExtensions().get("x-BbApiDeprecation-description");
        if (deprecatedFromVersion == null && removedFromVersion == null && reason == null && description == null) {
            return Optional.empty();
        }
        StringBuilder sb = new StringBuilder("## Deprecated\n");
        if (deprecatedFromVersion != null) {
            sb.append("* **Deprecated from:** ").append(deprecatedFromVersion).append("\n");
        }
        if (removedFromVersion != null) {
            sb.append("* **Removed from:** ").append(removedFromVersion).append("\n");
        }
        if (reason != null) {
            sb.append("* **Reason:** ").append(reason).append("\n");
        }
        if (description != null) {
            sb.append("\n### Migration Information\n ");
            sb.append(description);
        }
        return Optional.of(sb.toString());
    }

    private void pimpInfo(String version, OpenAPI openApi) {
        Info info = openApi.getInfo();
        if (version != null) {
            log.info("Overriding version: {}", (Object)version);
            info.setVersion(version);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.xLogoUrl)) {
            HashMap<String, String> xLogo = new HashMap<String, String>();
            xLogo.put("url", this.xLogoUrl);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.xLogoAltText)) {
                xLogo.put("altText", this.xLogoAltText);
            }
            info.addExtension("x-logo", xLogo);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.markdownTop)) {
            if (info.getDescription() != null) {
                info.setDescription(this.markdownTop + "\n" + info.getDescription());
            } else {
                info.setDescription(this.markdownTop);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.markdownBottom)) {
            if (info.getDescription() != null) {
                info.setDescription(info.getDescription() + "\n" + this.markdownBottom);
            } else {
                info.setDescription(this.markdownBottom);
            }
        }
        if (!this.servers.isEmpty()) {
            openApi.setServers(this.servers);
        }
    }

    protected void writeSummary(String title) {
        int total = this.success.size() + this.failed.size();
        if (total == 0) {
            this.getLog().warn((CharSequence)"Nothing to export");
            return;
        }
        int percent = this.failed.size() * 100 / total;
        log.info(title);
        log.info("\t Total: {} Success: {} Failed: {} ({}%)", new Object[]{total, this.success.size(), this.failed.size(), percent});
        if (!this.success.isEmpty()) {
            log.info("Success:");
            for (Map.Entry<File, OpenAPI> entry : this.success.entrySet()) {
                log.info("\t{} --> {}", (Object)entry.getKey(), (Object)entry.getValue().getInfo().getTitle());
            }
        }
        if (!this.failed.isEmpty()) {
            log.warn("Failed:");
            for (Map.Entry<Object, Object> entry : this.failed.entrySet()) {
                log.warn("\t{} Failed. Exception: {}", entry.getKey(), entry.getValue());
            }
        }
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public Map<File, OpenAPI> getSuccess() {
        return this.success;
    }

    public Map<String, String> getFailed() {
        return this.failed;
    }

    protected List<File> exportArtifact(String groupId, String artifactId, String version, File artifactFile, File outputDirectory) throws MojoExecutionException {
        log.info("Converting RAML specs from Artifact {}:{}:{} from: {}", new Object[]{groupId, artifactId, version, artifactFile});
        File specUnzipDirectory = new File(this.project.getBuild().getDirectory() + "/raml/" + version, artifactId);
        this.unzipSpec(artifactFile, specUnzipDirectory);
        Object[] files = this.findAllRamlSpecs(specUnzipDirectory);
        ArrayUtils.reverse((Object[])files);
        ArrayList<File> exported = new ArrayList<File>();
        for (Object file : files) {
            String ramlName = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)((File)file).getName(), (String)".");
            File fileParent = ((File)file).getParentFile();
            try {
                File openApiOutputDirectory;
                File parent;
                if (!fileParent.equals(specUnzipDirectory)) {
                    openApiOutputDirectory = parent = new File(outputDirectory, artifactId + File.separator + fileParent.getName() + File.separator + ramlName);
                } else {
                    parent = new File(outputDirectory, artifactId + File.separator + ramlName);
                    openApiOutputDirectory = new File(parent, ramlName);
                }
                if (this.includeVersionInOutputDirectory) {
                    openApiOutputDirectory = new File(openApiOutputDirectory, version);
                }
                File exportedTo = this.export(version, (File)file, openApiOutputDirectory);
                exported.add(exportedTo);
            }
            catch (Exception e) {
                if (!this.continueOnError) {
                    throw new MojoExecutionException("Failed to export RAML: " + ((File)file).getAbsolutePath(), e);
                }
                this.getLog().error((CharSequence)("Failed to export RAML Spec: " + file + " due to: [" + e.getClass() + "] " + e.getMessage()));
                this.failed.put(artifactId + ":" + ramlName, e.getMessage());
            }
        }
        this.getLog().info((CharSequence)("Exported RAML Spec: " + artifactId + " to: " + outputDirectory));
        return exported;
    }

    private File[] findAllRamlSpecs(File specUnzipDirectory) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(specUnzipDirectory);
        directoryScanner.setIncludes(this.ramlFileFilters.replace(" ", "").split(","));
        directoryScanner.scan();
        String[] includedFiles = directoryScanner.getIncludedFiles();
        return Arrays.stream(includedFiles).map(pathname -> new File(specUnzipDirectory, (String)pathname)).collect(Collectors.toList()).toArray(new File[0]);
    }

    private void unzipSpec(File inputFile, File unzipDirectory) throws MojoExecutionException {
        unzipDirectory.mkdirs();
        try {
            this.unzip(inputFile, unzipDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error extracting spec: " + inputFile, e);
        }
    }

    private void unzip(File source, File out) throws Exception {
        Expand expand = new Expand();
        expand.setSrc(source);
        expand.setDest(out);
        expand.setOverwrite(true);
        expand.execute();
    }

    public static void setLog(Logger log) {
        AbstractRamlToOpenApi.log = log;
    }

    public void setIncludeGroupIds(String includeGroupIds) {
        this.includeGroupIds = includeGroupIds;
    }

    public void setxLogoUrl(String xLogoUrl) {
        this.xLogoUrl = xLogoUrl;
    }

    public void setxLogoAltText(String xLogoAltText) {
        this.xLogoAltText = xLogoAltText;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setMarkdownTop(String markdownTop) {
        this.markdownTop = markdownTop;
    }

    public void setMarkdownBottom(String markdownBottom) {
        this.markdownBottom = markdownBottom;
    }

    public void setConvertJsonExamplesToYaml(boolean convertJsonExamplesToYaml) {
        this.convertJsonExamplesToYaml = convertJsonExamplesToYaml;
    }

    public void setAppendDeprecatedMetadataInDescription(boolean appendDeprecatedMetadataInDescription) {
        this.appendDeprecatedMetadataInDescription = appendDeprecatedMetadataInDescription;
    }

    public void setDecompose(boolean decompose) {
        this.decompose = decompose;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public ArtifactResult resolveArtifactFromRepositories(Artifact artifact) {
        ArtifactRequest artifactRequest = this.getArtifactRequest(artifact);
        ArtifactResult artifactResult = null;
        try {
            artifactResult = this.artifactResolver.resolveArtifact(this.repositorySession, artifactRequest);
        }
        catch (ArtifactResolutionException e) {
            throw new IllegalArgumentException("Cannot resolve artifact: " + artifact);
        }
        return artifactResult;
    }

    private ArtifactRequest getArtifactRequest(Artifact artifact) {
        return new ArtifactRequest(artifact, this.remoteRepositories, null);
    }

    protected DefaultArtifact createNewDefaultArtifact(Dependency dependency) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), StringUtils.isNotEmpty((String)dependency.getClassifier()) ? dependency.getClassifier() : null, StringUtils.isNotEmpty((String)dependency.getType()) ? dependency.getType() : null, dependency.getVersion());
    }
}

