/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.Utils;
import com.backbase.oss.boat.loader.OpenAPILoader;
import com.backbase.oss.boat.loader.OpenAPILoaderException;
import com.backbase.oss.boat.serializer.SerializerUtils;
import com.backbase.oss.boat.transformers.Bundler;
import com.backbase.oss.boat.transformers.SpecVersionTransformer;
import com.backbase.oss.boat.transformers.VendorExtensionFilter;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="bundle", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class BundleMojo
extends AbstractMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BundleMojo.class);
    @Parameter(name="input", required=true)
    private File input;
    @Parameter(name="includes", required=false, defaultValue="*.yaml")
    private String includes;
    @Parameter(name="output", required=true)
    private File output;
    @Parameter(name="version", required=false)
    private String version;
    @Parameter(name="versionFileName", required=false)
    private boolean versionFileName = false;
    @Parameter(name="removeExtensions", required=false, defaultValue="")
    private List<String> removeExtensions;
    @Parameter(name="skip", property="bundle.skip", defaultValue="false", alias="codegen.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] outputFiles;
        File[] inputFiles;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping OpenAPI bundle.");
            return;
        }
        log.info("Bundling OpenAPI: {} to: {}", (Object)this.input, (Object)this.output);
        if (this.input.isDirectory() && this.output.getName().endsWith(".yaml")) {
            throw new MojoExecutionException("Both input and output need to be either a directory or a file.");
        }
        if (this.input.isDirectory()) {
            String[] inputs;
            try {
                inputs = Utils.selectInputs((Path)this.input.toPath(), (String)this.includes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot scan input " + this.input, (Exception)e);
            }
            inputFiles = (File[])Arrays.stream(inputs).map(file -> new File(this.input, (String)file)).toArray(File[]::new);
            outputFiles = (File[])Arrays.stream(inputs).map(file -> new File(this.output, (String)file)).toArray(File[]::new);
            log.info("Found " + inputFiles.length + " specs to bundle.");
        } else {
            inputFiles = new File[]{this.input};
            outputFiles = new File[]{this.output};
        }
        for (int i = 0; i < inputFiles.length; ++i) {
            this.bundleOpenAPI(inputFiles[i], outputFiles[i]);
        }
    }

    private void bundleOpenAPI(File inputFile, File outputFile) throws MojoExecutionException {
        try {
            File directory;
            OpenAPI openAPI = OpenAPILoader.load((File)inputFile);
            if (StringUtils.isNotBlank((CharSequence)this.version)) {
                openAPI = new SpecVersionTransformer(this.version).transform(openAPI);
            }
            openAPI = new Bundler(inputFile).transform(openAPI);
            if (CollectionUtils.isNotEmpty(this.removeExtensions)) {
                openAPI = new VendorExtensionFilter().transform(openAPI, Collections.singletonMap("remove", this.removeExtensions));
            }
            if (!(directory = outputFile.getParentFile()).exists()) {
                directory.mkdirs();
            }
            if (this.versionFileName) {
                String versionedFileName = this.versionFileName(outputFile.getAbsolutePath(), openAPI);
                outputFile = Paths.get(versionedFileName, new String[0]).toFile();
            }
            Files.write(outputFile.toPath(), SerializerUtils.toYamlString((OpenAPI)openAPI).getBytes(), StandardOpenOption.CREATE);
        }
        catch (OpenAPILoaderException | IOException e) {
            throw new MojoExecutionException("Error transforming OpenAPI: {}" + inputFile, (Exception)e);
        }
    }

    String versionFileName(String originalFileName, OpenAPI openAPI) throws MojoExecutionException {
        String majorFromVersion;
        String openApiVersion;
        String string = openApiVersion = openAPI.getInfo() != null ? openAPI.getInfo().getVersion() : null;
        if (openApiVersion == null) {
            throw new MojoExecutionException("Configured to use version in filename, but no version set.");
        }
        String majorFromFileName = originalFileName.replaceAll("^(.*api-v)([0-9]+)(\\.yaml$)", "$2");
        if (!majorFromFileName.equals(majorFromVersion = openApiVersion.substring(0, openApiVersion.indexOf(".")))) {
            throw new MojoExecutionException("Invalid version " + openApiVersion + " in file " + originalFileName);
        }
        return originalFileName.replaceAll("^(.*api-v)([0-9]+)(\\.yaml$)", "$1" + openApiVersion + "$3");
    }

    @Generated
    public File getInput() {
        return this.input;
    }

    @Generated
    public String getIncludes() {
        return this.includes;
    }

    @Generated
    public File getOutput() {
        return this.output;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isVersionFileName() {
        return this.versionFileName;
    }

    @Generated
    public List<String> getRemoveExtensions() {
        return this.removeExtensions;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public void setInput(File input) {
        this.input = input;
    }

    @Generated
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    @Generated
    public void setOutput(File output) {
        this.output = output;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setVersionFileName(boolean versionFileName) {
        this.versionFileName = versionFileName;
    }

    @Generated
    public void setRemoveExtensions(List<String> removeExtensions) {
        this.removeExtensions = removeExtensions;
    }

    @Generated
    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

