/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import java.util.List;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class ArtifactRepositoryResolver {
    private final ArtifactResolver artifactResolver;
    private final RepositorySystemSession repositorySession;
    private final List<RemoteRepository> remoteRepositories;

    public ArtifactRepositoryResolver(ArtifactResolver artifactResolver, RepositorySystemSession repositorySession, List<RemoteRepository> remoteRepositories) {
        this.artifactResolver = artifactResolver;
        this.repositorySession = repositorySession;
        this.remoteRepositories = remoteRepositories;
    }

    public ArtifactResult resolveArtifactFromRepositories(Artifact artifact) {
        ArtifactRequest artifactRequest = this.getArtifactRequest(artifact);
        ArtifactResult artifactResult = null;
        try {
            artifactResult = this.artifactResolver.resolveArtifact(this.repositorySession, artifactRequest);
        }
        catch (ArtifactResolutionException e) {
            throw new IllegalArgumentException("Cannot resolve artifact: " + artifact);
        }
        return artifactResult;
    }

    private ArtifactRequest getArtifactRequest(Artifact artifact) {
        return new ArtifactRequest(artifact, this.remoteRepositories, null);
    }
}

