/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.AbstractRamlToOpenApi;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="export", threadSafe=true)
public class ExportMojo
extends AbstractRamlToOpenApi {
    @Parameter(property="input", defaultValue="src/main/resources")
    protected File input;
    @Parameter(property="inputFile")
    protected File inputFile;
    @Parameter(property="failOnError", defaultValue="true")
    private boolean failOnError = true;

    public void execute() throws MojoExecutionException {
        File[] files;
        if (this.inputFile != null) {
            this.getLog().info((CharSequence)("Converting RAML Input File: " + this.inputFile));
            files = new File[]{this.inputFile};
        } else {
            this.getLog().info((CharSequence)("Converting RAML specs from Input Directory: " + this.input));
            files = this.getFilesFromInputDirectoru();
            if (files == null) {
                return;
            }
        }
        for (File file : files) {
            String ramlName = StringUtils.substringBeforeLast((String)file.getName(), (String)".");
            try {
                File outputDirectory = new File(this.output, ramlName);
                this.export(null, file, outputDirectory);
                this.getLog().info((CharSequence)("Exported RAML Spec: " + ramlName));
            }
            catch (Exception e) {
                this.failed.put(ramlName, e.getMessage());
                String msg = "Failed to export RAML Spec: " + file.getName() + " due to: [" + e.getClass() + "] " + e.getMessage();
                this.getLog().error((CharSequence)msg);
                if (!this.failOnError) continue;
                throw new MojoExecutionException(msg, e);
            }
        }
        this.writeSummary("Converted RAML Specs to OpenAPI Summary");
    }

    private File[] getFilesFromInputDirectoru() throws MojoExecutionException {
        File[] files;
        if (!this.input.exists()) {
            String msg = "Input does not exist: " + this.input.getAbsolutePath();
            this.getLog().error((CharSequence)msg);
            if (this.failOnError) {
                throw new MojoExecutionException(msg);
            }
        }
        if ((files = this.input.listFiles(this::isRamlSpec)) == null || files.length == 0) {
            String msg = "Failed to find raml files in " + this.input.getAbsolutePath();
            this.getLog().error((CharSequence)msg);
            if (this.failOnError) {
                throw new MojoExecutionException(msg);
            }
            return new File[0];
        }
        return files;
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

