/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.GenerateMojo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateFromDirectoryDocMojo
extends GenerateMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenerateFromDirectoryDocMojo.class);
    @Parameter(defaultValue="**/*-api-*.yaml")
    protected String openApiFileFilters;
    @Parameter(property="markersDirectory", defaultValue="${project.build.directory}/boat-markers")
    protected File markersDirectory;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.inputSpec != null) {
            File inputSpecFile = new File(this.inputSpec);
            this.fileInputExecute(inputSpecFile);
        } else {
            log.info("Input read as Artifact");
            super.execute();
        }
    }

    private void fileInputExecute(File inputSpecFile) throws MojoExecutionException, MojoFailureException {
        if (inputSpecFile.isDirectory()) {
            log.info("inputSpec is being read as a directory");
            File outPutDirectory = this.output;
            File[] inputSpecs = this.findAllOpenApiSpecs(inputSpecFile);
            if (inputSpecs.length == 0) {
                log.warn("No OpenAPI specs found in: " + this.inputSpec);
            } else {
                ArrayList<File> success = new ArrayList<File>();
                ArrayList<File> failed = new ArrayList<File>();
                for (File inputSpec : inputSpecs) {
                    this.executeInputFile(outPutDirectory, success, failed, inputSpec);
                }
                this.writeMarkers(success, failed);
            }
        } else {
            log.info("inputSpec being read as a single file");
            super.execute();
        }
    }

    private void writeMarkers(List<File> success, List<File> failed) throws MojoExecutionException {
        if (this.markersDirectory != null) {
            try {
                if (!this.markersDirectory.exists()) {
                    Files.createDirectory(this.markersDirectory.toPath(), new FileAttribute[0]);
                }
                Files.write(new File(this.markersDirectory, "success.lst").toPath(), this.listOfFilesToString(success).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                Files.write(new File(this.markersDirectory, "failed.lst").toPath(), this.listOfFilesToString(failed).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                log.error("Failed to write BOAT markers to: {}", (Object)this.markersDirectory, (Object)e);
                throw new MojoExecutionException("Failed to write BOAT markers", (Exception)e);
            }
        }
    }

    private void executeInputFile(File outPutDirectory, List<File> success, List<File> failed, File f) {
        this.inputSpec = f.getPath();
        this.output = new File(outPutDirectory.getPath(), f.getName().substring(0, f.getName().lastIndexOf(".")));
        if (!this.output.exists()) {
            try {
                Files.createDirectory(this.output.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Failed to create output directory", (Throwable)e);
            }
        }
        log.info(" Generating docs for spec {} in directory", (Object)f.getName());
        try {
            super.execute();
            success.add(f);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            log.error("Failed to generate doc for spec: {}", (Object)this.inputSpec);
            failed.add(f);
        }
    }

    private String listOfFilesToString(List<File> files) {
        return files.stream().map(File::getPath).collect(Collectors.joining("\n"));
    }

    private File[] findAllOpenApiSpecs(File specDirectory) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(specDirectory);
        directoryScanner.setIncludes(this.openApiFileFilters.replace(" ", "").split(","));
        directoryScanner.scan();
        String[] includedFiles = directoryScanner.getIncludedFiles();
        return Arrays.stream(includedFiles).map(pathname -> new File(specDirectory, (String)pathname)).collect(Collectors.toList()).toArray(new File[0]);
    }
}

