/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputArtifact {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputArtifact.class);
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String classifier;
    private String fileName;
    private boolean overWrite;
    private boolean overWriteIfNewer;
    private boolean needsProcessing;

    public boolean isNeedsProcessing(File destFile, File originFile) {
        this.needsProcessing = this.overWrite || !destFile.exists() || this.overWriteIfNewer && this.isNewer(destFile, originFile);
        return this.needsProcessing;
    }

    private boolean isNewer(File destFile, File originFile) {
        try {
            long destMod = Files.getLastModifiedTime(destFile.toPath(), new LinkOption[0]).toMillis();
            long originMod = Files.getLastModifiedTime(originFile.toPath(), new LinkOption[0]).toMillis();
            return originMod > destMod;
        }
        catch (IOException e) {
            log.debug("Assuming artifact was not modified since artifact was last downloaded, cannot last read modified time");
            return false;
        }
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getClassifier() {
        return this.classifier;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public boolean isOverWrite() {
        return this.overWrite;
    }

    @Generated
    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    @Generated
    public boolean isNeedsProcessing() {
        return this.needsProcessing;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setOverWrite(boolean overWrite) {
        this.overWrite = overWrite;
    }

    @Generated
    public void setOverWriteIfNewer(boolean overWriteIfNewer) {
        this.overWriteIfNewer = overWriteIfNewer;
    }

    @Generated
    public void setNeedsProcessing(boolean needsProcessing) {
        this.needsProcessing = needsProcessing;
    }
}

