/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="ship", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ShipMojo
extends AbstractMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShipMojo.class);
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(name="input", required=true, defaultValue="${project.basedir}/src/main/resources")
    protected File input;
    @Parameter(name="includes", defaultValue="**/openapi.yaml, **/*api*.yaml")
    protected String[] includes;
    @Parameter(name="project", defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(defaultValue="${project.basedir}")
    private File baseDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] inputFiles;
        if (this.input.isDirectory()) {
            log.info("Scanning directory: {} with include patterns: {}", (Object)this.input, (Object)this.includes);
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(this.input);
            directoryScanner.setIncludes(this.includes);
            directoryScanner.scan();
            inputFiles = directoryScanner.getIncludedFiles();
            if (inputFiles.length == 0) {
                throw new MojoExecutionException("No API's found in directory: " + this.input + " with include patterns: " + Arrays.toString(this.includes));
            }
            log.info("Found " + inputFiles.length + " specs to sip");
        } else {
            inputFiles = new String[]{this.input.toPath().relativize(this.project.getBasedir().toPath()).toString()};
        }
        try {
            File apiZipFile = this.zip(inputFiles);
            log.info("Attaching API's to project reactor as {} ready to ship!", (Object)apiZipFile);
            this.projectHelper.attachArtifact(this.project, "zip", "api", apiZipFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to zip files due to: " + e.getMessage(), (Exception)e);
        }
    }

    private File zip(String[] inputFiles) throws IOException {
        File api = ShipMojo.createFileName(new File(this.project.getBuild().getOutputDirectory()), this.finalName, "api");
        log.info("Zipping OpenApi Files: {} to: {}", (Object)inputFiles, (Object)api);
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(this.input);
        fileSet.setUsingDefaultExcludes(true);
        fileSet.setIncludes(inputFiles);
        ZipArchiver zipArchiver = new ZipArchiver();
        zipArchiver.addFileSet((FileSet)fileSet);
        zipArchiver.setDestFile(api);
        zipArchiver.createArchive();
        return zipArchiver.getDestFile();
    }

    public static File createFileName(File basedir, String resultFinalName, String classifier) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (resultFinalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        String fileName = resultFinalName + "-" + classifier + ".zip";
        return new File(basedir, fileName);
    }

    @Generated
    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    @Generated
    public File getInput() {
        return this.input;
    }

    @Generated
    public String[] getIncludes() {
        return this.includes;
    }

    @Generated
    public MavenProject getProject() {
        return this.project;
    }

    @Generated
    public String getFinalName() {
        return this.finalName;
    }

    @Generated
    public File getBaseDir() {
        return this.baseDir;
    }

    @Generated
    public void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    @Generated
    public void setInput(File input) {
        this.input = input;
    }

    @Generated
    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Generated
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Generated
    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    @Generated
    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

