/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.AbstractRamlToOpenApi;
import com.backbase.oss.boat.ArtifactRepositoryResolver;
import com.backbase.oss.boat.diff.BatchOpenApiDiff;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="export-bom", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ExportBomMojo
extends AbstractRamlToOpenApi {
    public static final String X_CHANGELOG = "x-changelog";
    private static final Logger log = LoggerFactory.getLogger(ExportBomMojo.class);
    @Parameter(property="includeVersionsRegEx", defaultValue="^(\\d+\\.)?(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$")
    private String includeVersionsRegEx;
    @Parameter(property="includeArtifactIdRegEx", defaultValue="(\\w-spec)$")
    private String includeArtifactIdRegEx;
    @Parameter(property="spec-bom")
    private Dependency specBom;
    @Parameter(name="addChangeLog", defaultValue="true")
    private boolean addChangeLog;

    public void setSpecBom(Dependency specBom) {
        this.specBom = specBom;
    }

    public void execute() throws MojoExecutionException {
        Set metadataRequests = this.remoteRepositories.stream().map(remoteRepository -> this.createMetadataRequest((RemoteRepository)remoteRepository, "maven-metadata.xml")).collect(Collectors.toSet());
        metadataRequests.add(this.createMetadataRequest(null, "maven-metadata.xml"));
        VersionRange versionRange = this.getVersionRange();
        log.info("Checking BOM Meta Data for: {}:{}", (Object)this.specBom.getGroupId(), (Object)this.specBom.getArtifactId());
        List metadataResults = this.metadataResolver.resolveMetadata(this.repositorySession, metadataRequests);
        List remoteMetaData = metadataResults.stream().filter(MetadataResult::isResolved).collect(Collectors.toList());
        if (remoteMetaData.isEmpty()) {
            log.warn("Failed to resolve meta data for: {}:{}. Exiting", (Object)this.specBom.getGroupId(), (Object)this.specBom.getArtifactId());
            return;
        }
        List metaDataList = remoteMetaData.stream().map(metadataResult -> metadataResult.getMetadata().getFile()).collect(Collectors.toList());
        log.info("Resolved meta data for: {}:{} in: {}", new Object[]{this.specBom.getGroupId(), this.specBom.getArtifactId(), metaDataList});
        List versions = metaDataList.stream().map(this::parseMetadataFile).flatMap(metadata -> metadata.getVersioning().getVersions().stream()).filter(version -> {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.includeVersionsRegEx)) {
                return version.matches(this.includeVersionsRegEx);
            }
            return true;
        }).collect(Collectors.toList());
        log.info("Resolved versions: {}", versions);
        List<Pair<String, TreeMap<String, Set<ArtifactResult>>>> versionCapabilitySpecs = versions.stream().map(DefaultArtifactVersion::new).filter(arg_0 -> ((VersionRange)versionRange).containsVersion(arg_0)).distinct().map(this::convertToArtifact).map(defaultArtifact -> new ArtifactRepositoryResolver(this.artifactResolver, this.repositorySession, this.remoteRepositories).resolveArtifactFromRepositories((Artifact)defaultArtifact)).map(this::parsePomFile).map(this::groupArtifactsPerVersionAndCapability).collect(Collectors.toList());
        if (versionCapabilitySpecs.isEmpty()) {
            log.info("No specs found in bom!");
            return;
        }
        log.info("Converting {} RAML specs found in bom", (Object)versionCapabilitySpecs.size());
        this.export(versionCapabilitySpecs);
        this.writeSummary("Converted RAML Specs to OpenAPI Summary");
        if (this.addChangeLog && !versionCapabilitySpecs.isEmpty()) {
            try {
                this.success.clear();
                this.failed.clear();
                BatchOpenApiDiff.diff(this.output.toPath(), this.success, this.failed, true, true);
                this.writeSummary("Calculated Change log for APIs");
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot create diff", e);
            }
        }
    }

    private Pair<String, TreeMap<String, Set<ArtifactResult>>> groupArtifactsPerVersionAndCapability(Model model) {
        Set<Dependency> dependencies = this.getAllDependenciesFromBom(model);
        TreeMap collect = dependencies.stream().filter(this::isIncludedSpec).map(this::createNewDefaultArtifact).distinct().map(defaultArtifact -> new ArtifactRepositoryResolver(this.artifactResolver, this.repositorySession, this.remoteRepositories).resolveArtifactFromRepositories((Artifact)defaultArtifact)).collect(Collectors.groupingBy(artifactResult -> artifactResult.getArtifact().getGroupId(), TreeMap::new, Collectors.toSet()));
        return Pair.of((Object)model.getVersion(), (Object)collect);
    }

    private Set<Dependency> getAllDependenciesFromBom(Model model) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        if (model.getDependencyManagement() != null) {
            dependencies.addAll(model.getDependencyManagement().getDependencies());
        }
        if (model.getDependencies() != null) {
            dependencies.addAll(model.getDependencies());
        }
        if (model.getProfiles() != null) {
            model.getProfiles().forEach(profile -> dependencies.addAll(profile.getDependencies()));
        }
        return dependencies;
    }

    protected void export(List<Pair<String, TreeMap<String, Set<ArtifactResult>>>> versionCapabilitySpecs) throws MojoExecutionException {
        for (Pair<String, TreeMap<String, Set<ArtifactResult>>> versionSpecs : versionCapabilitySpecs) {
            String version = (String)versionSpecs.getKey();
            for (Map.Entry entry : ((TreeMap)versionSpecs.getValue()).entrySet()) {
                String capabilty = (String)entry.getKey();
                Set specs = (Set)entry.getValue();
                File capabilityDirectory = new File(this.output, capabilty);
                try {
                    Files.createDirectories(capabilityDirectory.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot create output directory: " + capabilityDirectory);
                }
                specs.stream().filter(ArtifactResult::isResolved).map(ArtifactResult::getArtifact).forEach(artifact -> {
                    try {
                        List<File> files = this.exportArtifact(artifact.getGroupId(), artifact.getArtifactId(), version, artifact.getFile(), capabilityDirectory);
                        log.info("Successfully exported artifact: {} to: {}", artifact, files);
                    }
                    catch (MojoExecutionException e) {
                        log.error("Failed to export artifact: {}", artifact, (Object)e);
                    }
                });
                specs.stream().filter(ArtifactResult::isMissing).forEach(artifactResult -> log.error("Failed to resolve: {}", artifactResult));
            }
        }
    }

    private boolean isIncludedSpec(Dependency dependency) {
        String artifactId = dependency.getArtifactId();
        return artifactId.endsWith("-spec");
    }

    private VersionRange getVersionRange() throws MojoExecutionException {
        try {
            return VersionRange.createFromVersionSpec((String)this.specBom.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Cannot parse version: " + this.specBom.getVersion());
        }
    }

    private MetadataRequest createMetadataRequest(RemoteRepository remoteRepository, String type) {
        MetadataRequest metadataRequest = new MetadataRequest();
        if (remoteRepository != null) {
            metadataRequest.setRepository(remoteRepository);
        }
        metadataRequest.setMetadata((Metadata)new DefaultMetadata(this.specBom.getGroupId(), this.specBom.getArtifactId(), type, Metadata.Nature.RELEASE_OR_SNAPSHOT));
        return metadataRequest;
    }

    private org.apache.maven.artifact.repository.metadata.Metadata parseMetadataFile(File mavenDataFile) {
        MetadataXpp3Reader metadataXpp3Reader = new MetadataXpp3Reader();
        try {
            FileInputStream in = new FileInputStream(mavenDataFile);
            return metadataXpp3Reader.read((InputStream)in);
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalArgumentException("Cannot read metadata from: " + mavenDataFile, e);
        }
    }

    public Model parsePomFile(ArtifactResult pom) {
        Model model;
        File pomFile = pom.getArtifact().getFile();
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            model = reader.read((Reader)new FileReader(pomFile));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot read pom file");
        }
        Properties properties = model.getProperties();
        ArrayList<Dependency> dependencyManagementDependencies = new ArrayList();
        if (model.getDependencyManagement() != null) {
            dependencyManagementDependencies = model.getDependencyManagement().getDependencies().stream().map(dependency -> this.resolvePropertyPlaceholderVersion(properties, (Dependency)dependency)).collect(Collectors.toList());
        }
        if (model.getDependencies() != null) {
            for (Dependency dependency2 : model.getDependencies()) {
                if (dependency2.getVersion() == null) {
                    this.setManagedVersionDependency(dependencyManagementDependencies, dependency2);
                    continue;
                }
                this.resolvePropertyPlaceholderVersion(properties, dependency2);
            }
        }
        if (model.getProfiles() != null) {
            for (Profile profile : model.getProfiles()) {
                log.info("Exporting spec from profile: {}", (Object)profile.getId());
                List profileDependencies = profile.getDependencies().stream().map(dependency -> this.resolvePropertyPlaceholderVersion(properties, (Dependency)dependency)).collect(Collectors.toList());
                for (Dependency dependency3 : profileDependencies) {
                    this.setManagedVersionDependency(dependencyManagementDependencies, dependency3);
                }
            }
        }
        return model;
    }

    private Dependency resolvePropertyPlaceholderVersion(Properties properties, Dependency dependency) {
        if (dependency.getVersion() != null && dependency.getVersion().contains("$")) {
            dependency.setVersion(this.replacePlaceholders(properties, dependency.getVersion()));
        }
        return dependency;
    }

    private void setManagedVersionDependency(List<Dependency> dependencyManagementDependencies, Dependency profileDependency) {
        if (profileDependency.getVersion() != null) {
            return;
        }
        Optional<Dependency> managedDependency = this.resolveDependencyVersion(dependencyManagementDependencies, profileDependency);
        managedDependency.ifPresent(dependency -> profileDependency.setVersion(dependency.getVersion()));
    }

    private Optional<Dependency> resolveDependencyVersion(List<Dependency> dependencyManagementDependencies, Dependency profileDependency) {
        return dependencyManagementDependencies.stream().filter(dependency -> profileDependency.getArtifactId().equals(dependency.getArtifactId()) && profileDependency.getGroupId().equals(dependency.getGroupId()) && profileDependency.getType().equals(dependency.getType())).findFirst();
    }

    private String replacePlaceholders(Properties properties, String template) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(template);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            if (!properties.containsKey(matcher.group(1))) continue;
            String replacement = properties.get(matcher.group(1)).toString();
            matcher.appendReplacement(buffer, replacement != null ? Matcher.quoteReplacement(replacement) : "null");
        }
        matcher.appendTail(buffer);
        String s = buffer.toString();
        log.debug("Replaced placeholder: {} with: {}", (Object)template, (Object)s);
        return s;
    }

    protected DefaultArtifact convertToArtifact(DefaultArtifactVersion defaultArtifactVersion) {
        return new DefaultArtifact(this.specBom.getGroupId(), this.specBom.getArtifactId(), StringUtils.isNotEmpty((String)this.specBom.getClassifier()) ? this.specBom.getClassifier() : null, StringUtils.isNotEmpty((String)this.specBom.getType()) ? this.specBom.getType() : null, defaultArtifactVersion.toString());
    }
}

