/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.AbstractRamlToOpenApi;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="export-dep", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class ExportDependenciesMojo
extends AbstractRamlToOpenApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportDependenciesMojo.class);

    public void execute() throws MojoExecutionException {
        List artifacts = this.project.getArtifacts().stream().filter(dependency -> dependency.getGroupId().startsWith(this.includeGroupIds)).filter(dependency -> dependency.getArtifactId().endsWith("-spec") || dependency.getArtifactId().endsWith("-specs")).collect(Collectors.toList());
        for (Artifact artifact : artifacts) {
            this.export(artifact);
        }
        this.writeSummary("Exported Project Dependencies");
    }

    private void export(Artifact artifact) throws MojoExecutionException {
        File outputDirectory = new File(this.output, artifact.getGroupId().replace('.', '/'));
        log.info("Export artifact: {} to: {}", (Object)artifact.getFile(), (Object)outputDirectory);
        this.exportArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getFile(), outputDirectory);
    }
}

