/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.loader.OpenAPILoader;
import com.backbase.oss.boat.loader.OpenAPILoaderException;
import com.backbase.oss.boat.serializer.SerializerUtils;
import com.backbase.oss.boat.transformers.Deprecator;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="remove-deprecated", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class RemoveDeprecatedMojo
extends AbstractMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoveDeprecatedMojo.class);
    @Parameter(name="input", required=true)
    private File input;
    @Parameter(name="output", required=true)
    private File output;

    public void setInput(File input) {
        this.input = input;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        log.debug("Removing deprecated objects in OpenAPI: {} to: {}", (Object)this.input, (Object)this.output);
        OpenAPI openAPI = null;
        try {
            openAPI = OpenAPILoader.load((File)this.input);
            new Deprecator().transform(openAPI, null);
            Files.write(this.output.toPath(), SerializerUtils.toYamlString((OpenAPI)openAPI).getBytes(), StandardOpenOption.CREATE);
        }
        catch (OpenAPILoaderException | IOException e) {
            throw new MojoExecutionException("Error transforming OpenAPI: {}" + this.input, (Exception)e);
        }
    }
}

