/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.bay.client.auth;

import feign.RequestInterceptor;
import feign.RequestTemplate;

public class HttpBearerAuth
implements RequestInterceptor {
    private final String scheme;
    private String bearerToken;

    public HttpBearerAuth(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public void apply(RequestTemplate template) {
        if (this.bearerToken == null) {
            return;
        }
        template.header("Authorization", new String[]{(String)(this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + this.bearerToken});
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

