/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.radio;

import com.backbase.oss.boat.Utils;
import com.backbase.oss.boat.bay.client.ApiClient;
import com.backbase.oss.boat.bay.client.api.BoatMavenPluginApi;
import com.backbase.oss.boat.bay.client.model.BoatLintReport;
import com.backbase.oss.boat.bay.client.model.Changes;
import com.backbase.oss.boat.bay.client.model.Severity;
import com.backbase.oss.boat.bay.client.model.UploadRequestBody;
import com.backbase.oss.boat.bay.client.model.UploadSpec;
import com.backbase.oss.boat.loader.OpenAPILoader;
import com.backbase.oss.boat.loader.OpenAPILoaderException;
import com.backbase.oss.boat.radio.SpecConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="radio", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class RadioMojo
extends AbstractMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RadioMojo.class);
    @Parameter(property="groupId", defaultValue="${project.groupId}")
    private String groupId;
    @Parameter(property="artifactId", defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(property="version", defaultValue="${project.version}")
    private String version;
    @Parameter(property="boat.bay.url", required=true)
    private String boatBayUrl;
    @Parameter(property="failOnBreakingChange", defaultValue="false")
    private boolean failOnBreakingChange;
    @Parameter(property="failOnLintViolation", defaultValue="false")
    private boolean failOnLintViolation;
    @Parameter(property="failOnBoatBayErrorResponse", defaultValue="false")
    private boolean failOnBoatBayErrorResponse;
    @Parameter(property="portalKey", required=true)
    private String portalKey;
    @Parameter(property="sourceKey", required=true)
    private String sourceKey;
    @Parameter(property="boat.bay.username")
    private String boatBayUsername;
    @Parameter(property="boat.bay.password")
    private String boatBayPassword;
    @Parameter(property="specs", required=true)
    private SpecConfig[] specs;
    @Parameter(name="radioOutput", defaultValue="${project.build.directory}/target/boat-radio-report")
    private File radioOutput;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<BoatLintReport> reports;
        ObjectMapper objectMapper;
        block11: {
            BasicAuthRequestInterceptor basicAuthRequestInterceptor = null;
            objectMapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
            if (StringUtils.isNotEmpty((CharSequence)this.boatBayUsername) && StringUtils.isNotEmpty((CharSequence)this.boatBayPassword)) {
                this.getLog().info((CharSequence)("Basic Authentication set for username " + this.boatBayUsername));
                basicAuthRequestInterceptor = new BasicAuthRequestInterceptor(this.boatBayUsername, this.boatBayPassword);
            } else {
                this.getLog().info((CharSequence)"No Authentication set");
            }
            ArrayList<UploadSpec> allSpecs = new ArrayList<UploadSpec>();
            for (SpecConfig spec : this.specs) {
                allSpecs.add(this.mapToUploadSpec(spec));
            }
            ApiClient apiClient = new ApiClient().setBasePath(this.boatBayUrl);
            if (basicAuthRequestInterceptor != null) {
                apiClient.addAuthorization("Basic Auth", (RequestInterceptor)basicAuthRequestInterceptor);
            }
            BoatMavenPluginApi api = apiClient.buildClient(BoatMavenPluginApi.class);
            UploadRequestBody uploadRequestBody = UploadRequestBody.builder().groupId(this.groupId).artifactId(this.artifactId).version(this.version).specs(allSpecs).build();
            reports = null;
            try {
                reports = api.uploadSpec(this.portalKey, this.sourceKey, uploadRequestBody);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("BoatBay error :: " + e.getMessage()));
                if (!this.failOnBoatBayErrorResponse) break block11;
                throw new MojoFailureException("BoatBay error", (Throwable)e);
            }
        }
        if (reports != null) {
            try {
                boolean doesSpecsHaveMustViolations;
                boolean doesSpecsHaveBreakingChanges;
                File outputFile = new File(this.getOutput(), "radioOutput.json");
                objectMapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, reports);
                reports.forEach(report -> {
                    this.getLog().info((CharSequence)String.format("Spec %s summary :", report.getSpec().getKey()));
                    this.getLog().info((CharSequence)String.format("Changes are %s ", new Object[]{report.getSpec().getChanges()}));
                    this.getLog().info((CharSequence)("Number of Violations:" + report.getViolations().size()));
                });
                this.getLog().info((CharSequence)("UPLOAD TO BOAT-BAY SUCCESSFUL, check the full report: " + outputFile.getCanonicalPath()));
                if (this.failOnBreakingChange && (doesSpecsHaveBreakingChanges = reports.stream().anyMatch(report -> report.getSpec().getChanges().equals((Object)Changes.BREAKING)))) {
                    throw new MojoFailureException("Specs have Breaking Changes. Check full report.");
                }
                if (this.failOnLintViolation && (doesSpecsHaveMustViolations = reports.stream().anyMatch(report -> report.getViolations().stream().anyMatch(violation -> violation.getSeverity().equals((Object)Severity.MUST))))) {
                    throw new MojoFailureException("Specs have Must Violations. Check full report.");
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to write output", (Throwable)e);
            }
        }
    }

    private UploadSpec mapToUploadSpec(SpecConfig spec) throws MojoExecutionException {
        String name;
        String contents;
        File inputSpecFile = new File(spec.getInputSpec());
        File inputParent = inputSpecFile.getParentFile();
        if (inputParent.isDirectory()) {
            try {
                String[] files = Utils.selectInputs((Path)inputParent.toPath(), (String)inputSpecFile.getName());
                switch (files.length) {
                    case 0: {
                        String noFileMessage = String.format("Input spec %s doesn't match any local file", spec.getInputSpec());
                        this.getLog().error((CharSequence)noFileMessage);
                        throw new MojoExecutionException(noFileMessage);
                    }
                    case 1: {
                        inputSpecFile = new File(inputParent, files[0]);
                        spec.setInputSpec(inputSpecFile.getAbsolutePath());
                        break;
                    }
                    default: {
                        String message = String.format("Input spec %s matches more than one single file", spec.getInputSpec());
                        this.getLog().error((CharSequence)message);
                        Stream.of(files).forEach(f -> this.getLog().error((CharSequence)String.format("    %s", f)));
                        throw new MojoExecutionException(message);
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot find input " + spec.getInputSpec());
            }
        } else {
            String message = String.format("Invalid parent spec folder %s ", spec.getInputSpec());
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
        try {
            contents = IOUtils.toString((URI)inputSpecFile.toURI(), (Charset)Charset.defaultCharset());
            OpenAPILoader.parse((String)contents);
        }
        catch (IOException e) {
            String msg = "Invalid File Path: " + inputSpecFile.getName();
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg, (Exception)e);
        }
        catch (OpenAPILoaderException e) {
            String msg = "Invalid Open Api file: " + inputSpecFile.getName();
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg, (Exception)((Object)e));
        }
        String key = spec.getKey();
        if (key == null || key.isEmpty()) {
            key = inputSpecFile.getName().substring(0, inputSpecFile.getName().lastIndexOf("-"));
        }
        if ((name = spec.getName()) == null || name.isEmpty()) {
            name = inputSpecFile.getName();
        }
        UploadSpec uploadSpec = UploadSpec.builder().fileName(inputSpecFile.getName()).key(key).name(name).openApi(contents).build();
        return uploadSpec;
    }

    private File getOutput() {
        if (this.radioOutput == null) {
            this.radioOutput = new File("./target/boat-radio-report");
        }
        if (!this.radioOutput.exists()) {
            this.radioOutput.mkdirs();
        }
        return this.radioOutput;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getBoatBayUrl() {
        return this.boatBayUrl;
    }

    @Generated
    public boolean isFailOnBreakingChange() {
        return this.failOnBreakingChange;
    }

    @Generated
    public boolean isFailOnLintViolation() {
        return this.failOnLintViolation;
    }

    @Generated
    public boolean isFailOnBoatBayErrorResponse() {
        return this.failOnBoatBayErrorResponse;
    }

    @Generated
    public String getPortalKey() {
        return this.portalKey;
    }

    @Generated
    public String getSourceKey() {
        return this.sourceKey;
    }

    @Generated
    public String getBoatBayUsername() {
        return this.boatBayUsername;
    }

    @Generated
    public String getBoatBayPassword() {
        return this.boatBayPassword;
    }

    @Generated
    public SpecConfig[] getSpecs() {
        return this.specs;
    }

    @Generated
    public File getRadioOutput() {
        return this.radioOutput;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setBoatBayUrl(String boatBayUrl) {
        this.boatBayUrl = boatBayUrl;
    }

    @Generated
    public void setFailOnBreakingChange(boolean failOnBreakingChange) {
        this.failOnBreakingChange = failOnBreakingChange;
    }

    @Generated
    public void setFailOnLintViolation(boolean failOnLintViolation) {
        this.failOnLintViolation = failOnLintViolation;
    }

    @Generated
    public void setFailOnBoatBayErrorResponse(boolean failOnBoatBayErrorResponse) {
        this.failOnBoatBayErrorResponse = failOnBoatBayErrorResponse;
    }

    @Generated
    public void setPortalKey(String portalKey) {
        this.portalKey = portalKey;
    }

    @Generated
    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    @Generated
    public void setBoatBayUsername(String boatBayUsername) {
        this.boatBayUsername = boatBayUsername;
    }

    @Generated
    public void setBoatBayPassword(String boatBayPassword) {
        this.boatBayPassword = boatBayPassword;
    }

    @Generated
    public void setSpecs(SpecConfig[] specs) {
        this.specs = specs;
    }

    @Generated
    public void setRadioOutput(File radioOutput) {
        this.radioOutput = radioOutput;
    }
}

