/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.GenerateMojo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenerateMojo
extends GenerateMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGenerateMojo.class);
    private static final Collection<String> EMBEDDED_SUPPORTING_FILES = List.of("ApiClient.java", "BeanValidationException.java", "RFC3339DateFormat.java", "ServerConfiguration.java", "ServerVariable.java", "StringUtil.java", "Authentication.java", "HttpBasicAuth.java", "HttpBearerAuth.java", "ApiKeyAuth.java", "JavaTimeFormatter.java");

    public void execute(String generatorName, String library, boolean isEmbedded, boolean reactive, boolean generateSupportingFiles) throws MojoExecutionException, MojoFailureException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("library", library);
        options.put("java8", "true");
        options.put("dateLibrary", "java8");
        options.put("reactive", Boolean.toString(reactive));
        options.put("performBeanValidation", "true");
        options.put("skipDefaultInterface", "true");
        options.put("interfaceOnly", "true");
        options.put("useTags", "true");
        options.put("useBeanValidation", "true");
        options.put("useClassLevelBeanValidation", "false");
        options.put("useOptional", "false");
        options.put("useJakartaEe", "true");
        options.put("useSpringBoot3", "true");
        options.put("containerDefaultToNull", "false");
        this.generatorName = generatorName;
        this.generateSupportingFiles = generateSupportingFiles;
        this.generateApiTests = !isEmbedded;
        this.generateApiDocumentation = !isEmbedded;
        this.generateModelDocumentation = !isEmbedded;
        this.generateModelTests = !isEmbedded;
        this.skipOverwrite = true;
        this.configOptions = this.configOptions == null ? options : AbstractGenerateMojo.mergeOptions(options, this.configOptions);
        log.debug("Using configOptions={}", (Object)this.configOptions);
        if (isEmbedded) {
            this.supportingFilesToGenerate = AbstractGenerateMojo.uniqueJoin(EMBEDDED_SUPPORTING_FILES);
        }
        super.execute();
    }

    private static Map<?, ?> mergeOptions(Map<String, String> defaultOptions, Map<?, ?> overrides) {
        HashMap<String, String> merged = new HashMap<String, String>();
        merged.putAll(defaultOptions);
        merged.putAll(overrides);
        return merged;
    }
}

