/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openapitools.openapidiff.core.OpenApiCompare;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.output.ConsoleRender;
import org.openapitools.openapidiff.core.output.HtmlRender;
import org.openapitools.openapidiff.core.output.MarkdownRender;
import org.openapitools.openapidiff.core.output.Render;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="diff", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DiffMojo
extends AbstractMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiffMojo.class);
    public static final String X_CHANGELOG = "x-changelog";
    @Parameter(name="oldFile", defaultValue="true")
    private File oldFile;
    @Parameter(name="newFile", defaultValue="true")
    private File newFile;
    @Parameter(name="breakOnBreakingChanges", defaultValue="true")
    private boolean breakOnBreakingChanges;
    @Parameter(name="writeChangelog", defaultValue="false")
    private boolean writeChangelog;
    @Parameter(name="changelogRenderer", defaultValue="markdown")
    private String changelogRenderer;
    @Parameter(name="changelogOutput", defaultValue="${project.build.directory}/changelog")
    private File changelogOutput;

    public void execute() throws MojoExecutionException {
        ChangedOpenApi changedOpenApi = OpenApiCompare.fromFiles((File)this.oldFile, (File)this.newFile);
        ConsoleRender consoleRender = new ConsoleRender();
        if (changedOpenApi.isIncompatible()) {
            log.error("\n{}", (Object)DiffMojo.renderChangedOpenApi((Render)consoleRender, changedOpenApi));
            if (this.breakOnBreakingChanges) {
                throw new MojoExecutionException("newFile: " + this.newFile + " contains breaking changes!");
            }
        } else {
            log.info("\n{}", (Object)DiffMojo.renderChangedOpenApi((Render)consoleRender, changedOpenApi));
        }
        if (this.writeChangelog) {
            String extension;
            MarkdownRender render;
            if ("markdown".equals(this.changelogRenderer)) {
                render = new MarkdownRender();
                extension = "md";
            } else if ("html".equals(this.changelogRenderer)) {
                render = new HtmlRender();
                extension = "html";
            } else {
                throw new MojoExecutionException("Invalid changelogRender. Supported types are 'markdown' and 'html");
            }
            File output = new File(this.changelogOutput, "changelog." + extension);
            try (FileOutputStream outputStream = new FileOutputStream(output);){
                render.render(changedOpenApi, new OutputStreamWriter(outputStream));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write output", (Exception)e);
            }
        }
    }

    public static String renderChangedOpenApi(Render render, ChangedOpenApi changedOpenApi) throws MojoExecutionException {
        String string;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            render.render(changedOpenApi, new OutputStreamWriter(outputStream));
            string = ((Object)outputStream).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
        ((OutputStream)outputStream).close();
        return string;
    }

    public void setNewFile(File newFile) {
        this.newFile = newFile;
    }

    public void setOldFile(File oldFile) {
        this.oldFile = oldFile;
    }

    public void setBreakOnBreakingChanges(boolean breakOnBreakingChanges) {
        this.breakOnBreakingChanges = breakOnBreakingChanges;
    }

    public boolean isWriteChangelog() {
        return this.writeChangelog;
    }

    public void setWriteChangelog(boolean writeChangelog) {
        this.writeChangelog = writeChangelog;
    }

    public String getChangelogRenderer() {
        return this.changelogRenderer;
    }

    public void setChangelogRenderer(String changelogRenderer) {
        this.changelogRenderer = changelogRenderer;
    }

    public File getChangelogOutput() {
        return this.changelogOutput;
    }

    public void setChangelogOutput(File changelogOutput) {
        this.changelogOutput = changelogOutput;
    }
}

