/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.bay.client.model;

import com.backbase.oss.boat.bay.client.model.BoatSpec;
import com.backbase.oss.boat.bay.client.model.BoatViolation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;

@JsonPropertyOrder(value={"id", "spec", "name", "passed", "lintedOn", "openApi", "version", "grade", "violations"})
public class BoatLintReport {
    public static final String JSON_PROPERTY_ID = "id";
    private BigDecimal id;
    public static final String JSON_PROPERTY_SPEC = "spec";
    private BoatSpec spec;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PASSED = "passed";
    private Boolean passed;
    public static final String JSON_PROPERTY_LINTED_ON = "lintedOn";
    private OffsetDateTime lintedOn;
    public static final String JSON_PROPERTY_OPEN_API = "openApi";
    private String openApi;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    public static final String JSON_PROPERTY_GRADE = "grade";
    private String grade;
    public static final String JSON_PROPERTY_VIOLATIONS = "violations";
    private List<BoatViolation> violations = new ArrayList<BoatViolation>();

    public BoatLintReport() {
    }

    public BoatLintReport id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(BigDecimal id) {
        this.id = id;
    }

    public BoatLintReport spec(BoatSpec spec) {
        this.spec = spec;
        return this;
    }

    @Nonnull
    @JsonProperty(value="spec")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BoatSpec getSpec() {
        return this.spec;
    }

    @JsonProperty(value="spec")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSpec(BoatSpec spec) {
        this.spec = spec;
    }

    public BoatLintReport name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public BoatLintReport passed(Boolean passed) {
        this.passed = passed;
        return this;
    }

    @Nonnull
    @JsonProperty(value="passed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getPassed() {
        return this.passed;
    }

    @JsonProperty(value="passed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassed(Boolean passed) {
        this.passed = passed;
    }

    public BoatLintReport lintedOn(OffsetDateTime lintedOn) {
        this.lintedOn = lintedOn;
        return this;
    }

    @Nonnull
    @JsonProperty(value="lintedOn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getLintedOn() {
        return this.lintedOn;
    }

    @JsonProperty(value="lintedOn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLintedOn(OffsetDateTime lintedOn) {
        this.lintedOn = lintedOn;
    }

    public BoatLintReport openApi(String openApi) {
        this.openApi = openApi;
        return this;
    }

    @Nonnull
    @JsonProperty(value="openApi")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOpenApi() {
        return this.openApi;
    }

    @JsonProperty(value="openApi")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOpenApi(String openApi) {
        this.openApi = openApi;
    }

    public BoatLintReport version(String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersion(String version) {
        this.version = version;
    }

    public BoatLintReport grade(String grade) {
        this.grade = grade;
        return this;
    }

    @Nonnull
    @JsonProperty(value="grade")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGrade() {
        return this.grade;
    }

    @JsonProperty(value="grade")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGrade(String grade) {
        this.grade = grade;
    }

    public BoatLintReport violations(List<BoatViolation> violations) {
        this.violations = violations;
        return this;
    }

    public BoatLintReport addViolationsItem(BoatViolation violationsItem) {
        if (this.violations == null) {
            this.violations = new ArrayList<BoatViolation>();
        }
        this.violations.add(violationsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="violations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BoatViolation> getViolations() {
        return this.violations;
    }

    @JsonProperty(value="violations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setViolations(List<BoatViolation> violations) {
        this.violations = violations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoatLintReport boatLintReport = (BoatLintReport)o;
        return Objects.equals(this.id, boatLintReport.id) && Objects.equals(this.spec, boatLintReport.spec) && Objects.equals(this.name, boatLintReport.name) && Objects.equals(this.passed, boatLintReport.passed) && Objects.equals(this.lintedOn, boatLintReport.lintedOn) && Objects.equals(this.openApi, boatLintReport.openApi) && Objects.equals(this.version, boatLintReport.version) && Objects.equals(this.grade, boatLintReport.grade) && Objects.equals(this.violations, boatLintReport.violations);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.spec, this.name, this.passed, this.lintedOn, this.openApi, this.version, this.grade, this.violations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BoatLintReport {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    passed: ").append(this.toIndentedString(this.passed)).append("\n");
        sb.append("    lintedOn: ").append(this.toIndentedString(this.lintedOn)).append("\n");
        sb.append("    openApi: ").append(this.toIndentedString(this.openApi)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    grade: ").append(this.toIndentedString(this.grade)).append("\n");
        sb.append("    violations: ").append(this.toIndentedString(this.violations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Generated
    public static BoatLintReportBuilder builder() {
        return new BoatLintReportBuilder();
    }

    @Generated
    public BoatLintReport(BigDecimal id, BoatSpec spec, String name, Boolean passed, OffsetDateTime lintedOn, String openApi, String version, String grade, List<BoatViolation> violations) {
        this.id = id;
        this.spec = spec;
        this.name = name;
        this.passed = passed;
        this.lintedOn = lintedOn;
        this.openApi = openApi;
        this.version = version;
        this.grade = grade;
        this.violations = violations;
    }

    @Generated
    public static class BoatLintReportBuilder {
        @Generated
        private BigDecimal id;
        @Generated
        private BoatSpec spec;
        @Generated
        private String name;
        @Generated
        private Boolean passed;
        @Generated
        private OffsetDateTime lintedOn;
        @Generated
        private String openApi;
        @Generated
        private String version;
        @Generated
        private String grade;
        @Generated
        private List<BoatViolation> violations;

        @Generated
        BoatLintReportBuilder() {
        }

        @Generated
        public BoatLintReportBuilder id(BigDecimal id) {
            this.id = id;
            return this;
        }

        @Generated
        public BoatLintReportBuilder spec(BoatSpec spec) {
            this.spec = spec;
            return this;
        }

        @Generated
        public BoatLintReportBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public BoatLintReportBuilder passed(Boolean passed) {
            this.passed = passed;
            return this;
        }

        @Generated
        public BoatLintReportBuilder lintedOn(OffsetDateTime lintedOn) {
            this.lintedOn = lintedOn;
            return this;
        }

        @Generated
        public BoatLintReportBuilder openApi(String openApi) {
            this.openApi = openApi;
            return this;
        }

        @Generated
        public BoatLintReportBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public BoatLintReportBuilder grade(String grade) {
            this.grade = grade;
            return this;
        }

        @Generated
        public BoatLintReportBuilder violations(List<BoatViolation> violations) {
            this.violations = violations;
            return this;
        }

        @Generated
        public BoatLintReport build() {
            return new BoatLintReport(this.id, this.spec, this.name, this.passed, this.lintedOn, this.openApi, this.version, this.grade, this.violations);
        }

        @Generated
        public String toString() {
            return "BoatLintReport.BoatLintReportBuilder(id=" + this.id + ", spec=" + this.spec + ", name=" + this.name + ", passed=" + this.passed + ", lintedOn=" + this.lintedOn + ", openApi=" + this.openApi + ", version=" + this.version + ", grade=" + this.grade + ", violations=" + this.violations + ")";
        }
    }
}

