/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.serializer.SerializerUtils;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="validate", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ValidateMojo
extends AbstractMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateMojo.class);
    @Parameter(name="input", required=true)
    private File input;
    @Parameter(name="failOnWarning", required=true)
    private boolean failOnWarning;

    public void setInput(File input) {
        this.input = input;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    public void execute() throws MojoFailureException {
        if (!this.input.exists()) {
            throw new MojoFailureException("File not found: " + this.input.getName());
        }
        if (this.input.isDirectory()) {
            log.info("Validating files '*.yaml' in: {}", (Object)this.input);
            for (File inputFile : this.input.listFiles(pathname -> StringUtils.endsWith((CharSequence)pathname.getName(), (CharSequence)".yaml"))) {
                this.validate(inputFile);
            }
        } else {
            this.validate(this.input);
        }
    }

    private void validate(File inputFile) throws MojoFailureException {
        log.info("Validating {}", (Object)inputFile);
        OpenAPIParser openAPIParser = new OpenAPIParser();
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setFlatten(true);
        parseOptions.setResolveFully(true);
        SwaggerParseResult swaggerParseResult = openAPIParser.readLocation(inputFile.toURI().toString(), new ArrayList(), parseOptions);
        if (swaggerParseResult.getMessages() != null && swaggerParseResult.getMessages().isEmpty()) {
            log.info("OpenAPI: {} is valid", (Object)swaggerParseResult.getOpenAPI().getInfo().getTitle());
        } else {
            if (swaggerParseResult.getMessages() != null) {
                for (String message : swaggerParseResult.getMessages()) {
                    this.processMessages(message, inputFile, swaggerParseResult);
                }
            }
            if (this.failOnWarning) {
                throw new MojoFailureException("Validation errors validating OpenAPI");
            }
        }
    }

    private void processMessages(String message, File inputFile, SwaggerParseResult swaggerParseResult) {
        if (this.failOnWarning) {
            log.error("Validation errors while parsing OpenAPI: {}", (Object)inputFile.getName());
            log.error(message);
        } else {
            log.warn("Validation errors while parsing OpenAPI: {}", (Object)inputFile.getName());
            log.warn(message);
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug("Dumping open api");
                log.debug(SerializerUtils.toYamlString((OpenAPI)swaggerParseResult.getOpenAPI()));
            }
            catch (RuntimeException e) {
                log.debug("That did not end well: ", (Throwable)e);
            }
        }
    }
}

