/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.loader.OpenAPILoader;
import com.backbase.oss.boat.loader.OpenAPILoaderException;
import com.backbase.oss.boat.serializer.SerializerUtils;
import com.backbase.oss.boat.transformers.Bundler;
import com.backbase.oss.boat.transformers.ExtensionFilter;
import com.backbase.oss.boat.transformers.SetVersion;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="bundle", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class BundleMojo
extends AbstractMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BundleMojo.class);
    @Parameter(name="input", required=true, defaultValue="${project.basedir}/src/main/resources")
    private File input;
    @Parameter(name="includes", defaultValue="**/openapi.yaml, **/*api*.yaml")
    protected String[] includes;
    @Parameter(name="excludes", defaultValue="**/lib/**")
    protected String[] excludes;
    @Parameter(name="output", required=true, defaultValue="${project.build.directory}/openapi")
    private File output;
    @Parameter(name="flattenOutput", required=false)
    private boolean flattenOutput = false;
    @Parameter(name="version", required=false)
    private String version;
    @Parameter(name="versionFileName", required=false)
    private boolean versionFileName = false;
    @Parameter(name="removeExtensions", required=false, defaultValue="")
    private List<String> removeExtensions;
    @Parameter(name="skip", property="bundle.skip", defaultValue="false", alias="codegen.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] outputFiles;
        File[] inputFiles;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping OpenAPI bundle.");
            return;
        }
        log.info("Bundling OpenAPI: {} to: {}", (Object)this.input, (Object)this.output);
        if (this.input.isDirectory() && this.output.getName().endsWith(".yaml")) {
            throw new MojoExecutionException("Both input and output need to be either a directory or a file.");
        }
        if (this.input.isDirectory()) {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(this.input);
            directoryScanner.setIncludes(this.includes);
            directoryScanner.setExcludes(this.excludes);
            directoryScanner.scan();
            String[] includedFiles = directoryScanner.getIncludedFiles();
            inputFiles = (File[])Arrays.stream(includedFiles).map(file -> new File(this.input, (String)file)).collect(Collectors.toList()).toArray(File[]::new);
            outputFiles = (File[])Arrays.stream(includedFiles).map(this::normalizeOutputFileName).map(file -> new File(this.output, (String)file)).toArray(File[]::new);
            log.info("Found " + inputFiles.length + " specs to bundle.");
        } else {
            inputFiles = new File[]{this.input};
            outputFiles = new File[]{this.output};
        }
        for (int i = 0; i < inputFiles.length; ++i) {
            this.bundleOpenAPI(inputFiles[i], outputFiles[i]);
        }
    }

    private void bundleOpenAPI(File inputFile, File outputFile) throws MojoExecutionException {
        try {
            File directory;
            log.info("Bundling {} into a single OpenAPI file: {}", (Object)inputFile, (Object)outputFile);
            OpenAPI openAPI = OpenAPILoader.load((File)inputFile);
            if (StringUtils.isNotBlank((CharSequence)this.version)) {
                openAPI = new SetVersion(this.version).transform(openAPI);
            }
            openAPI = new Bundler(inputFile).transform(openAPI);
            if (CollectionUtils.isNotEmpty(this.removeExtensions)) {
                openAPI = new ExtensionFilter().transform(openAPI, Collections.singletonMap("remove", this.removeExtensions));
            }
            if (!(directory = outputFile.getParentFile()).exists()) {
                directory.mkdirs();
            }
            if (this.versionFileName) {
                String versionedFileName = this.versionFileName(outputFile.getAbsolutePath(), openAPI);
                outputFile = Paths.get(versionedFileName, new String[0]).toFile();
            }
            Files.write(outputFile.toPath(), SerializerUtils.toYamlString((OpenAPI)openAPI).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            log.info("Bundled: {} into: {}", (Object)inputFile, (Object)outputFile);
        }
        catch (OpenAPILoaderException | IOException e) {
            throw new MojoExecutionException("Error transforming OpenAPI: {}" + String.valueOf(inputFile), (Exception)e);
        }
    }

    @VisibleForTesting
    String versionFileName(String originalFileName, OpenAPI openAPI) throws MojoExecutionException {
        String openApiVersion = Optional.ofNullable(openAPI.getInfo()).map(Info::getVersion).orElseThrow(() -> new MojoExecutionException("Configured to use version in filename, but no version set."));
        if (!openApiVersion.matches("^\\d\\..*")) {
            throw new MojoExecutionException("Version should be semver (or at least have a recognisable major version), but found '" + openApiVersion + "' (string starts with number and dot: 2.0.0, 2.blabla, 2.3.4.5.6.234234)");
        }
        String majorFromVersion = openApiVersion.substring(0, openApiVersion.indexOf("."));
        String majorFromFileName = originalFileName.replaceAll("^(.*api-v)([0-9]+)(\\.yaml$)", "$2");
        if (!majorFromFileName.equals(majorFromVersion)) {
            throw new MojoExecutionException("Invalid version " + openApiVersion + " in file " + originalFileName);
        }
        return originalFileName.replaceAll("^(.*api-v)([0-9]+)(\\.yaml$)", "$1" + openApiVersion + "$3");
    }

    @VisibleForTesting
    String normalizeOutputFileName(String outputFileName) {
        return this.flattenOutput ? new File(outputFileName).getName() : outputFileName;
    }

    @Generated
    public File getInput() {
        return this.input;
    }

    @Generated
    public String[] getIncludes() {
        return this.includes;
    }

    @Generated
    public String[] getExcludes() {
        return this.excludes;
    }

    @Generated
    public File getOutput() {
        return this.output;
    }

    @Generated
    public boolean isFlattenOutput() {
        return this.flattenOutput;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isVersionFileName() {
        return this.versionFileName;
    }

    @Generated
    public List<String> getRemoveExtensions() {
        return this.removeExtensions;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public void setInput(File input) {
        this.input = input;
    }

    @Generated
    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Generated
    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Generated
    public void setOutput(File output) {
        this.output = output;
    }

    @Generated
    public void setFlattenOutput(boolean flattenOutput) {
        this.flattenOutput = flattenOutput;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setVersionFileName(boolean versionFileName) {
        this.versionFileName = versionFileName;
    }

    @Generated
    public void setRemoveExtensions(List<String> removeExtensions) {
        this.removeExtensions = removeExtensions;
    }

    @Generated
    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

