/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.ArtifactRepositoryResolver;
import com.backbase.oss.boat.InputArtifact;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Expand;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputMavenArtifactMojo
extends AbstractMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputMavenArtifactMojo.class);
    @Parameter(name="inputMavenArtifact", property="inputMavenArtifact", required=false)
    protected InputArtifact inputMavenArtifact;
    @Parameter(name="input", required=false)
    protected File input;
    @Parameter(name="inputSpec", property="openapi.generator.maven.plugin.inputSpec", required=false)
    protected String inputSpec;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySession;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    protected List<RemoteRepository> remoteRepositories;
    private final ReentrantLock reLock = new ReentrantLock(true);

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.inputMavenArtifact != null && this.inputMavenArtifact.getArtifactId() != null) {
            this.getArtifact();
        }
        if (this.input == null && this.inputSpec == null && this.inputMavenArtifact == null) {
            throw new MojoExecutionException("Missing input from plugin, input options are: inputMavenArtifact, input, inputSpec");
        }
        if (this.input == null) {
            this.input = new File(this.inputSpec);
        }
    }

    private void getArtifact() throws MojoExecutionException {
        ArtifactResult result;
        File specUnzipDirectory = new File(this.project.getBuild().getDirectory() + File.separator + "input-artifact" + File.separator + this.inputMavenArtifact.getArtifactId(), this.inputMavenArtifact.getVersion());
        if (this.inputMavenArtifact.isNeedsProcessing(specUnzipDirectory, (result = new ArtifactRepositoryResolver(this.artifactResolver, this.repositorySession, this.remoteRepositories).resolveArtifactFromRepositories((Artifact)new DefaultArtifact(this.inputMavenArtifact.getGroupId(), this.inputMavenArtifact.getArtifactId(), this.inputMavenArtifact.getClassifier(), this.inputMavenArtifact.getType(), this.inputMavenArtifact.getVersion()))).getArtifact().getFile())) {
            this.unzipSpec(result.getArtifact().getFile(), specUnzipDirectory);
        }
        try (Stream<Path> walk = Files.walk(specUnzipDirectory.toPath(), new FileVisitOption[0]);){
            List paths = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.endsWith(this.inputMavenArtifact.getFileName())).map(Path::toString).collect(Collectors.toList());
            if (paths.size() > 1) {
                log.info("found multiple files of matching {} in zip, using {}", (Object)this.inputMavenArtifact.getFileName(), paths.get(0));
            } else if (paths.isEmpty()) {
                throw new MojoExecutionException("no file matching " + this.inputMavenArtifact.getFileName() + " was found in artifact zip");
            }
            this.inputSpec = (String)paths.get(0);
            this.input = new File((String)paths.get(0));
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            throw new MojoExecutionException("Could not search unzipped artifact directory");
        }
    }

    private void unzipSpec(File inputFile, File specUnzipDirectory) throws MojoExecutionException {
        this.reLock.lock();
        try {
            specUnzipDirectory.mkdirs();
            this.unzip(inputFile, specUnzipDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error extracting spec: " + String.valueOf(inputFile), e);
        }
        finally {
            this.reLock.unlock();
        }
    }

    private void unzip(File source, File out) throws Exception {
        Expand expand = new Expand();
        expand.setSrc(source);
        expand.setDest(out);
        expand.setOverwrite(true);
        expand.execute();
    }

    public void setInput(File input) {
        this.input = input;
    }
}

