/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.diff;

import com.backbase.oss.boat.DiffMojo;
import com.backbase.oss.boat.serializer.SerializerUtils;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.compare.OpenApiDiffOptions;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.output.MarkdownRender;
import org.openapitools.openapidiff.core.output.Render;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchOpenApiDiff {
    private static final Logger log = LoggerFactory.getLogger(BatchOpenApiDiff.class);
    private static final String X_CHANGELOG = "x-changelog";
    private static final MarkdownRender markdownRender = new MarkdownRender();

    public static void diff(Path outputDirectory, Map<File, OpenAPI> success, Map<String, String> failed, boolean insertIntoSpec, boolean writeChangeLogToSeparateFile) throws IOException {
        List sortedSpecs = Files.walk(outputDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(BatchOpenApiDiff::isOpenApiSpec).map(BatchOpenApiDiff::parseFileToParseResult).filter(BatchOpenApiDiff::isValidOpenApiSpec).map(BatchOpenApiDiff::mapToOpenAPIPair).sorted(BatchOpenApiDiff::sortVersions).collect(Collectors.toList());
        OpenApiDiffOptions diffOptions = OpenApiDiffOptions.builder().build();
        for (int i = 1; i < sortedSpecs.size(); ++i) {
            Pair oldVersionPair = (Pair)sortedSpecs.get(i - 1);
            Pair newVersionPair = (Pair)sortedSpecs.get(i);
            OpenAPI oldOpenAPI = (OpenAPI)oldVersionPair.getValue();
            OpenAPI newOpenAPI = (OpenAPI)newVersionPair.getValue();
            Path newOpenAPIPath = (Path)newVersionPair.getKey();
            try {
                ChangedOpenApi compare = OpenApiDiff.compare((OpenAPI)oldOpenAPI, (OpenAPI)newOpenAPI, (OpenApiDiffOptions)diffOptions);
                List<ChangedOpenApi> changeLog = BatchOpenApiDiff.getChangeLog(oldOpenAPI);
                changeLog.add(compare);
                String changelogMarkdown = BatchOpenApiDiff.renderChangeLog(changeLog);
                if (insertIntoSpec) {
                    BatchOpenApiDiff.writeChangelogInOpenAPI(newOpenAPIPath, changelogMarkdown);
                }
                if (writeChangeLogToSeparateFile) {
                    Path changeLogFile = newOpenAPIPath.getParent().resolve("changelog.md");
                    Files.write(changeLogFile, changelogMarkdown.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                }
                newOpenAPI.addExtension(X_CHANGELOG, changeLog);
                success.put(newOpenAPIPath.toFile(), newOpenAPI);
                log.debug("Including Changelog for: {} with version: {}", (Object)newOpenAPI.getInfo().getTitle(), (Object)newOpenAPI.getInfo().getVersion());
                continue;
            }
            catch (Exception e) {
                failed.put(newOpenAPI.toString(), e.getMessage());
            }
        }
    }

    private static int sortVersions(Pair<Path, OpenAPI> pair1, Pair<Path, OpenAPI> pair2) {
        return BatchOpenApiDiff.compareVersions(((OpenAPI)pair1.getRight()).getInfo().getVersion(), ((OpenAPI)pair2.getRight()).getInfo().getVersion());
    }

    private static Pair<Path, OpenAPI> mapToOpenAPIPair(Pair<Path, SwaggerParseResult> pair) {
        return Pair.of((Object)((Path)pair.getKey()), (Object)((SwaggerParseResult)pair.getRight()).getOpenAPI());
    }

    private static Pair<Path, SwaggerParseResult> parseFileToParseResult(Path path) {
        SwaggerParseResult right = BatchOpenApiDiff.parseOpenAPI(path);
        return Pair.of((Object)path, (Object)right);
    }

    private static boolean isOpenApiSpec(Path path) {
        return path.toString().endsWith(".yaml");
    }

    private static boolean isValidOpenApiSpec(Pair<Path, SwaggerParseResult> pair) {
        return ((SwaggerParseResult)pair.getRight()).getMessages().isEmpty();
    }

    private static void writeChangelogInOpenAPI(Path openApiFilePath, String changelogMarkdown) throws IOException {
        OpenAPI diffedApi = BatchOpenApiDiff.parseOpenAPI(openApiFilePath).getOpenAPI();
        if (diffedApi.getInfo().getDescription() == null) {
            diffedApi.getInfo().setDescription(changelogMarkdown);
        } else {
            diffedApi.getInfo().setDescription(diffedApi.getInfo().getDescription() + "\n" + changelogMarkdown);
        }
        diffedApi.addExtension("x-compared", (Object)true);
        log.debug("Writing change log back into OpenAPI");
        Files.write(openApiFilePath, SerializerUtils.toYamlString((OpenAPI)diffedApi).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
    }

    private static String renderChangeLog(List<ChangedOpenApi> changeLog) throws MojoExecutionException {
        StringBuilder markDown = new StringBuilder();
        markDown.append("# Changelog\n");
        for (ChangedOpenApi changedOpenApi : changeLog) {
            markDown.append(BatchOpenApiDiff.generateDiffReport(changedOpenApi));
        }
        return markDown.toString();
    }

    private static String generateDiffReport(ChangedOpenApi diff) throws MojoExecutionException {
        StringBuilder markDown = new StringBuilder();
        markDown.append("## ").append(diff.getOldSpecOpenApi().getInfo().getVersion()).append(" - ").append(diff.getNewSpecOpenApi().getInfo().getVersion()).append("\n");
        if (!diff.isDifferent()) {
            markDown.append("No Changes\n");
        } else {
            if (diff.isIncompatible()) {
                markDown.append("**Note:** API has incompatible changes!!\n");
            }
            markDown.append(DiffMojo.renderChangedOpenApi((Render)markdownRender, diff));
        }
        return markDown.toString();
    }

    private static List<ChangedOpenApi> getChangeLog(OpenAPI oldSpec) {
        List<Object> changeLog = oldSpec.getExtensions() != null && oldSpec.getExtensions().containsKey(X_CHANGELOG) ? (List)oldSpec.getExtensions().get(X_CHANGELOG) : new ArrayList<ChangedOpenApi>();
        return changeLog;
    }

    private static SwaggerParseResult parseOpenAPI(Path file) {
        log.info("Parsing OpenAPI: {}", (Object)file);
        OpenAPIParser openAPIParser = new OpenAPIParser();
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setFlatten(true);
        parseOptions.setResolveFully(true);
        SwaggerParseResult swaggerParseResult = openAPIParser.readLocation(file.toFile().toURI().toString(), new ArrayList(), parseOptions);
        for (String message : swaggerParseResult.getMessages()) {
            log.warn(message);
        }
        return swaggerParseResult;
    }

    private static int compareVersions(String v1, String v2) {
        DefaultArtifactVersion version1 = new DefaultArtifactVersion(v1);
        DefaultArtifactVersion version2 = new DefaultArtifactVersion(v2);
        return version1.compareTo((ArtifactVersion)version2);
    }

    @Generated
    private BatchOpenApiDiff() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

